/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest.impl;

import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaContent;
import io.apicurio.registry.ccompat.rest.SubjectsResource;
import io.apicurio.registry.ccompat.rest.impl.AbstractResource;
import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import java.util.List;
import javax.interceptor.Interceptors;

@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class SubjectsResourceImpl
extends AbstractResource
implements SubjectsResource {
    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public List<String> listSubjects() {
        return this.facade.getSubjects();
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public Schema findSchemaByContent(String subject, SchemaContent request) throws Exception {
        return this.facade.getSchema(subject, request);
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public List<Integer> deleteSubject(String subject) throws Exception {
        return this.facade.deleteSubject(subject);
    }
}

