/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.store;

import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaInfo;
import io.apicurio.registry.ccompat.dto.SubjectVersion;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.dto.StoredArtifactDto;
import io.apicurio.registry.types.ArtifactType;

public class FacadeConverter {
    public static int convertUnsigned(long value) {
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Value out of unsigned integer range: " + value);
        }
        return (int)value;
    }

    public static Schema convert(String subject, StoredArtifactDto storedArtifact) {
        return new Schema(FacadeConverter.convertUnsigned(storedArtifact.getContentId()), subject, FacadeConverter.convertUnsigned(storedArtifact.getVersionId()), storedArtifact.getContent().content());
    }

    public static SchemaInfo convert(ContentHandle content, ArtifactType artifactType) {
        return new SchemaInfo(content.content(), artifactType.value());
    }

    public static SubjectVersion convert(String artifactId, Number version) {
        return new SubjectVersion(artifactId, version.longValue());
    }
}

