/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.cncf.schemaregistry.impl;

import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.ccompat.rest.error.ConflictException;
import io.apicurio.registry.ccompat.rest.error.UnprocessableEntityException;
import io.apicurio.registry.cncf.schemaregistry.SchemagroupsResource;
import io.apicurio.registry.cncf.schemaregistry.beans.SchemaGroup;
import io.apicurio.registry.cncf.schemaregistry.beans.SchemaId;
import io.apicurio.registry.cncf.schemaregistry.impl.CNCFApiUtil;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.GroupAlreadyExistsException;
import io.apicurio.registry.storage.GroupNotFoundException;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactSearchResultsDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.storage.dto.SearchFilterType;
import io.apicurio.registry.storage.dto.StoredArtifactDto;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.util.ArtifactTypeUtil;
import io.apicurio.registry.util.VersionUtil;
import io.quarkus.security.identity.SecurityIdentity;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.interceptor.Interceptors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class SchemagroupsResourceImpl
implements SchemagroupsResource {
    private static final Integer GET_GROUPS_LIMIT = 1000;
    private static final String PROP_CONTENT_TYPE = "x-content-type";
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RulesService rulesService;
    @Context
    HttpServletRequest request;
    @Inject
    SecurityIdentity securityIdentity;

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public List<String> getGroups() {
        return this.storage.getGroupIds(GET_GROUPS_LIMIT);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public SchemaGroup getGroup(String groupId) {
        GroupMetaDataDto group = this.storage.getGroupMetaData(groupId);
        return CNCFApiUtil.dtoToSchemaGroup(group);
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Write)
    public void createGroup(String groupId, SchemaGroup data) {
        GroupMetaDataDto.GroupMetaDataDtoBuilder group = GroupMetaDataDto.builder().groupId(groupId).description(data.getDescription()).artifactsType(data.getFormat() != null ? ArtifactType.fromValue((String)data.getFormat()) : null).properties(data.getGroupProperties());
        String user = this.securityIdentity.getPrincipal().getName();
        try {
            group.createdBy(user).createdOn(new Date().getTime());
            this.storage.createGroup(group.build());
        }
        catch (GroupAlreadyExistsException e) {
            GroupMetaDataDto existing = this.storage.getGroupMetaData(groupId);
            group.createdBy(existing.getCreatedBy()).createdOn(existing.getCreatedOn()).modifiedBy(user).modifiedOn(new Date().getTime());
            this.storage.updateGroupMetaData(group.build());
        }
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Write)
    public void deleteGroup(String groupId) {
        this.storage.deleteGroup(groupId);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Read)
    public List<String> getSchemasByGroup(String groupId) {
        this.verifyGroupExists(groupId);
        HashSet<SearchFilter> filters = new HashSet<SearchFilter>();
        filters.add(new SearchFilter(SearchFilterType.group, groupId));
        ArtifactSearchResultsDto resultsDto = this.storage.searchArtifacts(filters, OrderBy.name, OrderDirection.asc, 0, 1000);
        return resultsDto.getArtifacts().stream().map(dto -> dto.getId()).collect(Collectors.toList());
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupOnly, level=AuthorizedLevel.Write)
    public void deleteSchemasByGroup(String groupId) {
        this.verifyGroupExists(groupId);
        this.storage.deleteArtifacts(groupId);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public Response getLatestSchema(String groupId, String schemaId) {
        this.verifyGroupExists(groupId);
        StoredArtifactDto artifact = this.storage.getArtifact(groupId, schemaId);
        ArtifactMetaDataDto metadata = this.storage.getArtifactMetaData(groupId, schemaId);
        String contentType = metadata.getProperties().get(PROP_CONTENT_TYPE);
        return Response.ok((Object)artifact.getContent(), (String)contentType).build();
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public SchemaId createSchema(String groupId, String schemaId, InputStream data) {
        ContentHandle content = ContentHandle.create(data);
        if (content.bytes().length == 0) {
            throw new BadRequestException("Error: Empty content");
        }
        try {
            this.verifyGroupExists(groupId);
        }
        catch (GroupNotFoundException e) {
            try {
                this.storage.createGroup(GroupMetaDataDto.builder().groupId(groupId).build());
            }
            catch (GroupAlreadyExistsException groupAlreadyExistsException) {
                // empty catch block
            }
        }
        try {
            this.storage.getArtifactVersionMetaData(groupId, schemaId, false, content);
            SchemaId id = new SchemaId();
            id.setId(schemaId);
            return id;
        }
        catch (ArtifactNotFoundException id) {
            ArtifactMetaDataDto res;
            ArtifactType artifactType = ArtifactTypeUtil.determineArtifactType(content, null, this.request.getContentType());
            EditableArtifactMetaDataDto metadata = new EditableArtifactMetaDataDto();
            metadata.setProperties(Map.of(PROP_CONTENT_TYPE, this.request.getContentType()));
            try {
                if (!this.artifactExists(groupId, schemaId)) {
                    this.rulesService.applyRules(groupId, schemaId, artifactType, content, RuleApplicationType.CREATE);
                    res = this.storage.createArtifactWithMetadata(groupId, schemaId, null, artifactType, content, metadata);
                } else {
                    this.rulesService.applyRules(groupId, schemaId, artifactType, content, RuleApplicationType.UPDATE);
                    res = this.storage.updateArtifactWithMetadata(groupId, schemaId, null, artifactType, content, metadata);
                }
            }
            catch (RuleViolationException ex) {
                if (ex.getRuleType() == RuleType.VALIDITY) {
                    throw new UnprocessableEntityException(ex.getMessage(), ex);
                }
                throw new ConflictException(ex.getMessage(), ex);
            }
            String artifactId = res.getId();
            SchemaId id2 = new SchemaId();
            id2.setId(artifactId);
            return id2;
        }
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteSchema(String groupId, String schemaId) {
        this.verifyGroupExists(groupId);
        this.storage.deleteArtifact(groupId, schemaId);
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public List<Integer> getSchemaVersions(String groupId, String schemaId) {
        this.verifyGroupExists(groupId);
        return this.storage.getArtifactVersions(groupId, schemaId).stream().map(v -> Long.valueOf(v).intValue()).collect(Collectors.toList());
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Read)
    public Response getSchemaVersion(String groupId, String schemaId, Integer versionNumber) {
        this.verifyGroupExists(groupId);
        StoredArtifactDto artifact = this.storage.getArtifactVersion(groupId, schemaId, VersionUtil.toString(versionNumber));
        ArtifactVersionMetaDataDto metadata = this.storage.getArtifactVersionMetaData(groupId, schemaId, VersionUtil.toString(versionNumber));
        String contentType = metadata.getProperties().get(PROP_CONTENT_TYPE);
        return Response.ok((Object)artifact.getContent(), (String)contentType).build();
    }

    @Override
    @Authorized(style=AuthorizedStyle.GroupAndArtifact, level=AuthorizedLevel.Write)
    public void deleteSchemaVersion(String groupId, String schemaId, Integer versionNumber) {
        this.verifyGroupExists(groupId);
        this.storage.deleteArtifactVersion(groupId, schemaId, VersionUtil.toString(versionNumber));
    }

    private boolean artifactExists(String groupId, String schemaId) {
        try {
            this.storage.getArtifactMetaData(groupId, schemaId);
            return true;
        }
        catch (ArtifactNotFoundException ignored) {
            return false;
        }
    }

    private void verifyGroupExists(String groupId) {
        this.storage.getGroupMetaData(groupId);
    }
}

