/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.extract;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.extract.ContentExtractor;
import io.apicurio.registry.content.extract.ExtractedMetaData;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class AvroContentExtractor
implements ContentExtractor {
    @Inject
    Logger log;
    private ObjectMapper mapper = new ObjectMapper();

    AvroContentExtractor() {
    }

    @Override
    public ExtractedMetaData extract(ContentHandle content) {
        try {
            JsonNode avroSchema = this.mapper.readTree(content.bytes());
            JsonNode name = avroSchema.get("name");
            ExtractedMetaData metaData = null;
            if (name != null && !name.isNull()) {
                metaData = new ExtractedMetaData();
                metaData.setName(name.asText());
            }
            return metaData;
        }
        catch (IOException e) {
            this.log.warn("Error extracting metadata from JSON: {}", (Object)e.getMessage());
            return null;
        }
    }
}

