/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.extract;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.extract.ContentExtractor;
import io.apicurio.registry.content.extract.ExtractedMetaData;
import io.apicurio.registry.util.DocumentBuilderAccessor;
import java.io.InputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.w3c.dom.Document;

@ApplicationScoped
public class WsdlOrXsdContentExtractor
implements ContentExtractor {
    @Inject
    Logger log;

    @Override
    public ExtractedMetaData extract(ContentHandle content) {
        ExtractedMetaData extractedMetaData;
        block11: {
            InputStream contentIS = content.stream();
            try {
                Document document = DocumentBuilderAccessor.getDocumentBuilder().parse(contentIS);
                String name = document.getDocumentElement().getAttribute("name");
                String targetNS = document.getDocumentElement().getAttribute("targetNamespace");
                ExtractedMetaData metaData = null;
                if (name != null && !name.equals("")) {
                    metaData = new ExtractedMetaData();
                    metaData.setName(name);
                } else if (targetNS != null && !targetNS.equals("")) {
                    metaData = new ExtractedMetaData();
                    metaData.setName(targetNS);
                }
                extractedMetaData = metaData;
                if (contentIS == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (contentIS != null) {
                        try {
                            contentIS.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.log.warn("Error extracting metadata from WSDL/XSD: {}", (Object)e.getMessage());
                    return null;
                }
            }
            contentIS.close();
        }
        return extractedMetaData;
    }
}

