/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.logging;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class LoggerProducer {
    private final Map<Class<?>, Logger> loggers = new ConcurrentHashMap();

    public Logger getLogger(Class<?> targetClass) {
        Logger logger = this.loggers.computeIfAbsent(targetClass, k -> LoggerFactory.getLogger((Class)targetClass));
        return logger;
    }

    @Produces
    public Logger produceLogger(InjectionPoint injectionPoint) {
        Class targetClass = injectionPoint.getBean().getBeanClass();
        return this.getLogger(targetClass);
    }
}

