/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics.health.liveness;

import io.apicurio.registry.services.http.RegistryExceptionMapperService;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class LivenessUtil {
    @Inject
    Logger log;
    @Inject
    @ConfigProperty(name="registry.liveness.errors.ignored")
    Optional<List<String>> ignored;

    public boolean isIgnoreError(Throwable ex) {
        boolean ignored = this.isIgnored(ex);
        if (ignored) {
            this.log.debug("Ignored intercepted exception: " + ex.getClass().getName() + " :: " + ex.getMessage());
        }
        return ignored;
    }

    private boolean isIgnored(Throwable ex) {
        Set<Class<? extends Exception>> ignoredClasses = RegistryExceptionMapperService.getIgnored();
        if (ignoredClasses.contains(ex.getClass())) {
            return true;
        }
        return this.ignored.isPresent() && this.ignored.get().contains(ex.getClass().getName());
    }
}

