/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics.health.liveness;

import io.apicurio.registry.metrics.health.AbstractErrorCounterHealthCheck;
import io.apicurio.registry.metrics.health.liveness.LivenessCheck;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Liveness;
import org.slf4j.Logger;

@ApplicationScoped
@Liveness
@Default
public class ResponseErrorLivenessCheck
extends AbstractErrorCounterHealthCheck
implements HealthCheck,
LivenessCheck {
    @Inject
    Logger log;
    @ConfigProperty(name="registry.metrics.ResponseErrorLivenessCheck.errorThreshold", defaultValue="1")
    Integer configErrorThreshold;
    @ConfigProperty(name="registry.metrics.ResponseErrorLivenessCheck.counterResetWindowDurationSec", defaultValue="60")
    Integer configCounterResetWindowDurationSec;
    @ConfigProperty(name="registry.metrics.ResponseErrorLivenessCheck.statusResetWindowDurationSec", defaultValue="300")
    Integer configStatusResetWindowDurationSec;
    @ConfigProperty(name="registry.metrics.ResponseErrorLivenessCheck.disableLogging", defaultValue="false")
    Boolean disableLogging;

    @PostConstruct
    void init() {
        this.init(this.configErrorThreshold, this.configCounterResetWindowDurationSec, this.configStatusResetWindowDurationSec);
    }

    public synchronized HealthCheckResponse call() {
        this.callSuper();
        return HealthCheckResponse.builder().name("ResponseErrorLivenessCheck").withData("errorCount", this.errorCounter).state(this.up).build();
    }

    @Override
    public void suspect(String reason) {
        if (this.disableLogging != Boolean.TRUE) {
            this.log.warn("Liveness problem suspected in ResponseErrorLivenessCheck: {}", (Object)reason);
        }
        super.suspectSuper();
        if (this.disableLogging != Boolean.TRUE) {
            this.log.info("After this event, the error counter is {} (out of the maximum {} allowed).", (Object)this.errorCounter, (Object)this.configErrorThreshold);
        }
    }

    @Override
    public void suspectWithException(Throwable reason) {
        if (this.disableLogging != Boolean.TRUE) {
            this.log.warn("Liveness problem suspected in ResponseErrorLivenessCheck because of an exception: ", reason);
        }
        super.suspectSuper();
        if (this.disableLogging != Boolean.TRUE) {
            this.log.info("After this event, the error counter is {} (out of the maximum {} allowed).", (Object)this.errorCounter, (Object)this.configErrorThreshold);
        }
    }
}

