/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics.health.readiness;

import io.apicurio.registry.metrics.health.readiness.PersistenceTimeoutReadinessApply;
import io.apicurio.registry.metrics.health.readiness.PersistenceTimeoutReadinessCheck;
import java.time.Instant;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;

@Interceptor
@Priority(value=2000)
@PersistenceTimeoutReadinessApply
public class PersistenceTimeoutReadinessInterceptor {
    @Inject
    Logger log;
    @Inject
    PersistenceTimeoutReadinessCheck check;

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        Instant start = Instant.now();
        Object result = context.proceed();
        if (start.plus(this.check.getTimeoutSec()).isBefore(Instant.now())) {
            this.check.suspect();
        }
        return result;
    }
}

