/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.mt;

import java.time.Duration;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class MultitenancyProperties {
    @Inject
    @ConfigProperty(name="registry.enable.multitenancy", defaultValue="false")
    boolean multitenancyEnabled;
    @Inject
    @ConfigProperty(name="registry.multitenancy.authorization.enabled", defaultValue="true")
    boolean mtAuthorizationEnabled;
    @Inject
    @ConfigProperty(name="registry.multitenancy.types.context-path.enabled", defaultValue="true")
    boolean mtContextPathEnabled;
    @Inject
    @ConfigProperty(name="registry.multitenancy.types.subdomain.enabled", defaultValue="true")
    boolean mtSubdomainEnabled;
    @Inject
    @ConfigProperty(name="registry.multitenancy.types.request-header.enabled", defaultValue="true")
    boolean mtRequestHeaderEnabled;
    @Inject
    @ConfigProperty(name="registry.multitenancy.types.context-path.base-path", defaultValue="t")
    String nameMultitenancyBasePath;
    @Inject
    @ConfigProperty(name="registry.multitenancy.types.subdomain.location", defaultValue="header")
    String subdomainMultitenancyLocation;
    @Inject
    @ConfigProperty(name="registry.multitenancy.types.subdomain.header-name", defaultValue="Host")
    String subdomainMultitenancyHeaderName;
    @Inject
    @ConfigProperty(name="registry.multitenancy.types.subdomain.pattern", defaultValue="(\\w[\\w\\d\\-]*)\\.localhost\\.local")
    String subdomainMultitenancyPattern;
    @Inject
    @ConfigProperty(name="registry.multitenancy.types.request-header.name", defaultValue="X-Registry-Tenant-Id")
    String tenantIdRequestHeader;
    @Inject
    @ConfigProperty(name="registry.multitenancy.reaper.every")
    Optional<String> reaperEvery;
    @Inject
    @ConfigProperty(name="registry.multitenancy.reaper.period-seconds", defaultValue="10800")
    Long reaperPeriodSeconds;
    @Inject
    @ConfigProperty(name="registry.tenant.manager.url")
    Optional<String> tenantManagerUrl;
    @Inject
    @ConfigProperty(name="registry.tenant.manager.auth.enabled")
    Optional<Boolean> tenantManagerAuthEnabled;
    @Inject
    @ConfigProperty(name="registry.tenant.manager.auth.url.configured")
    Optional<String> tenantManagerAuthUrl;
    @Inject
    @ConfigProperty(name="registry.tenant.manager.auth.client-id")
    Optional<String> tenantManagerClientId;
    @Inject
    @ConfigProperty(name="registry.tenant.manager.auth.client-secret")
    Optional<String> tenantManagerClientSecret;

    @PostConstruct
    void init() {
        this.reaperEvery.orElseThrow(() -> new IllegalArgumentException("Missing required configuration property 'registry.multitenancy.reaper.every'"));
    }

    public boolean isMultitenancyEnabled() {
        return this.multitenancyEnabled;
    }

    public boolean isMultitenancyAuthorizationEnabled() {
        return this.mtAuthorizationEnabled;
    }

    public boolean isMultitenancyContextPathEnabled() {
        return this.mtContextPathEnabled;
    }

    public boolean isMultitenancySubdomainEnabled() {
        return this.mtSubdomainEnabled;
    }

    public boolean isMultitenancyRequestHeaderEnabled() {
        return this.mtRequestHeaderEnabled;
    }

    public String getNameMultitenancyBasePath() {
        return this.nameMultitenancyBasePath;
    }

    public String getSubdomainMultitenancyLocation() {
        return this.subdomainMultitenancyLocation;
    }

    public String getSubdomainMultitenancyHeaderName() {
        return this.subdomainMultitenancyHeaderName;
    }

    public String getSubdomainMultitenancyPattern() {
        return this.subdomainMultitenancyPattern;
    }

    public String getTenantIdRequestHeader() {
        return this.tenantIdRequestHeader;
    }

    public Duration getReaperPeriod() {
        return Duration.ofSeconds(this.reaperPeriodSeconds);
    }

    public Optional<String> getTenantManagerUrl() {
        return this.tenantManagerUrl;
    }

    public boolean isTenantManagerAuthEnabled() {
        return this.tenantManagerAuthEnabled.orElse(Boolean.FALSE);
    }

    public Optional<String> getTenantManagerAuthUrl() {
        return this.tenantManagerAuthUrl;
    }

    public Optional<String> getTenantManagerClientId() {
        return this.tenantManagerClientId;
    }

    public Optional<String> getTenantManagerClientSecret() {
        return this.tenantManagerClientSecret;
    }
}

