/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.mt;

import io.apicurio.registry.mt.MultitenancyProperties;
import io.apicurio.registry.mt.RegistryTenantContext;
import io.apicurio.registry.mt.TenantContext;
import io.apicurio.registry.mt.TenantContextLoader;
import io.quarkus.runtime.StartupEvent;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class TenantIdResolver {
    private static final int TENANT_ID_POSITION = 2;
    String multitenancyBasePath;
    @Inject
    Logger log;
    @Inject
    MultitenancyProperties mtProperties;
    @Inject
    TenantContext tenantContext;
    @Inject
    TenantContextLoader contextLoader;
    Pattern subdomainNamePattern;

    void init(@Observes StartupEvent ev) {
        if (this.mtProperties.isMultitenancyEnabled()) {
            this.log.info("Registry running with multitenancy enabled");
        }
        this.multitenancyBasePath = "/" + this.mtProperties.getNameMultitenancyBasePath() + "/";
        if (this.mtProperties.isMultitenancySubdomainEnabled()) {
            this.subdomainNamePattern = Pattern.compile(this.mtProperties.getSubdomainMultitenancyPattern());
        }
    }

    public boolean resolveTenantId(String uri, Function<String, String> headerProvider, Supplier<String> serverNameProvider, Consumer<String> afterSuccessfullUrlResolution) {
        if (this.mtProperties.isMultitenancyEnabled()) {
            this.log.trace("Resolving tenantId...");
            if (this.mtProperties.isMultitenancyContextPathEnabled()) {
                this.log.trace("Resolving tenantId from path: {}", (Object)uri);
                if (uri.startsWith(this.multitenancyBasePath)) {
                    String[] tokens = uri.split("/");
                    String tenantId = tokens[2];
                    RegistryTenantContext context = this.contextLoader.loadRequestContext(tenantId);
                    this.tenantContext.setContext(context);
                    if (afterSuccessfullUrlResolution != null) {
                        afterSuccessfullUrlResolution.accept(tenantId);
                    }
                    return true;
                }
                this.log.warn("Context-path multi-tenancy enabled.  Detected unmatched path.");
            }
            if (this.mtProperties.isMultitenancySubdomainEnabled()) {
                this.log.trace("Resolving tenantId from subdomain.");
                String domain = null;
                String domainLocation = this.mtProperties.getSubdomainMultitenancyLocation();
                if (domainLocation.equals("header")) {
                    String domainHeaderName = this.mtProperties.getSubdomainMultitenancyHeaderName();
                    domain = headerProvider.apply(domainHeaderName);
                } else if (domainLocation.equals("serverName")) {
                    domain = serverNameProvider.get();
                } else {
                    this.log.warn("Unknown domain location: " + domainLocation);
                    domain = "";
                }
                Matcher matcher = this.subdomainNamePattern.matcher(domain);
                if (matcher.matches()) {
                    String tenantId = matcher.group(1);
                    if (tenantId != null) {
                        RegistryTenantContext context = this.contextLoader.loadRequestContext(tenantId);
                        this.tenantContext.setContext(context);
                        return true;
                    }
                } else {
                    this.log.warn("Subdomain multi-tenancy enabled.  Detected unmatched domain: " + domain);
                }
            }
            if (this.mtProperties.isMultitenancyRequestHeaderEnabled()) {
                String headerName = this.mtProperties.getTenantIdRequestHeader();
                this.log.trace("Resolving tenantId from request header named: {}", (Object)headerName);
                String tenantId = headerProvider.apply(headerName);
                if (tenantId != null) {
                    RegistryTenantContext context = this.contextLoader.loadRequestContext(tenantId);
                    this.tenantContext.setContext(context);
                    return true;
                }
                this.log.warn("Request header multi-tenancy enabled, but header value not found in request.");
            }
        }
        this.tenantContext.setContext(this.contextLoader.defaultTenantContext());
        return false;
    }

    public int tenantPrefixLength(String tenantId) {
        return (this.multitenancyBasePath + tenantId).length();
    }
}

