/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.mt;

import io.apicurio.multitenant.client.TenantManagerClient;
import io.apicurio.multitenant.client.TenantManagerClientImpl;
import io.apicurio.registry.mt.MultitenancyProperties;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.utils.OptionalBean;
import io.apicurio.rest.client.JdkHttpClientProvider;
import io.apicurio.rest.client.auth.Auth;
import io.apicurio.rest.client.auth.OidcAuth;
import io.apicurio.rest.client.spi.ApicurioHttpClientProvider;
import io.quarkus.runtime.configuration.ProfileManager;
import java.util.Collections;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.DeploymentException;
import javax.inject.Inject;

@ApplicationScoped
public class TenantManagerClientProducer {
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    MultitenancyProperties properties;

    @Produces
    @ApplicationScoped
    OptionalBean<TenantManagerClient> produce() {
        if (this.properties.isMultitenancyEnabled()) {
            if ("prod".equals(ProfileManager.getActiveProfile()) && !this.storage.supportsMultiTenancy()) {
                throw new DeploymentException("Unsupported configuration, \"registry.enable.multitenancy\" is enabled but the storage implementation being used (" + this.storage.storageName() + ") does not support multitenancy");
            }
            if (this.properties.getTenantManagerUrl().isEmpty()) {
                throw new DeploymentException("Unsupported configuration, \"registry.enable.multitenancy\" is enabled but the no \"registry.tenant.manager.url\" is provided");
            }
            if (this.properties.isTenantManagerAuthEnabled()) {
                if (this.properties.getTenantManagerAuthUrl().isEmpty() || this.properties.getTenantManagerClientId().isEmpty() || this.properties.getTenantManagerClientSecret().isEmpty()) {
                    throw new DeploymentException("Unsupported configuration, \"registry.enable.multitenancy\" is enabled \"registry.enable.auth\" is enabled but the no auth properties aren't properly configured");
                }
                return OptionalBean.of((Object)new TenantManagerClientImpl(this.properties.getTenantManagerUrl().get(), Collections.emptyMap(), (Auth)new OidcAuth((ApicurioHttpClientProvider)new JdkHttpClientProvider(), this.properties.getTenantManagerAuthUrl().get(), this.properties.getTenantManagerClientId().get(), this.properties.getTenantManagerClientSecret().get())));
            }
            return OptionalBean.of((Object)new TenantManagerClientImpl(this.properties.getTenantManagerUrl().get()));
        }
        return OptionalBean.empty();
    }
}

