/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.mt;

import io.apicurio.registry.mt.RegistryTenantContext;
import io.apicurio.registry.mt.TenantContextImpl;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class TenantThreadContextProvider
implements ThreadContextProvider {
    public ThreadContextSnapshot currentContext(Map<String, String> props) {
        RegistryTenantContext captured = TenantContextImpl.current();
        return () -> {
            RegistryTenantContext current = this.restore(captured);
            return () -> this.restore(current);
        };
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> props) {
        return () -> {
            RegistryTenantContext current = this.restore(null);
            return () -> this.restore(current);
        };
    }

    public String getThreadContextType() {
        return "Apicurio Registry Tenant";
    }

    private RegistryTenantContext restore(RegistryTenantContext context) {
        RegistryTenantContext currentContext = TenantContextImpl.current();
        if (context == null) {
            TenantContextImpl.clearCurrentContext();
        } else {
            TenantContextImpl.setCurrentContext(context);
        }
        return currentContext;
    }
}

