/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.mt.limits;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.mt.limits.LimitExceededException;
import io.apicurio.registry.mt.limits.LimitsCheckResult;
import io.apicurio.registry.mt.limits.TenantLimitsConfigurationService;
import io.apicurio.registry.mt.limits.TenantLimitsService;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.RegistryStorageException;
import io.apicurio.registry.storage.VersionNotFoundException;
import io.apicurio.registry.storage.decorator.RegistryStorageDecorator;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.RegistryException;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.context.ThreadContext;

@ApplicationScoped
public class RegistryStorageLimitsEnforcer
extends RegistryStorageDecorator {
    @Inject
    ThreadContext threadContext;
    @Inject
    TenantLimitsService limitsService;
    @Inject
    TenantLimitsConfigurationService limitsConfiguration;

    @Override
    public boolean isEnabled() {
        return this.limitsConfiguration.isConfigured();
    }

    @Override
    public int order() {
        return 0;
    }

    @Override
    public ArtifactMetaDataDto createArtifact(String groupId, String artifactId, String version, ArtifactType artifactType, ContentHandle content) throws ArtifactAlreadyExistsException, RegistryStorageException {
        ArtifactMetaDataDto dto = this.withLimitsCheck(() -> this.limitsService.canCreateArtifact(null)).execute(() -> super.createArtifact(groupId, artifactId, version, artifactType, content));
        this.limitsService.artifactCreated();
        return dto;
    }

    @Override
    public ArtifactMetaDataDto createArtifactWithMetadata(String groupId, String artifactId, String version, ArtifactType artifactType, ContentHandle content, EditableArtifactMetaDataDto metaData) throws ArtifactAlreadyExistsException, RegistryStorageException {
        ArtifactMetaDataDto dto = this.withLimitsCheck(() -> this.limitsService.canCreateArtifact(metaData)).execute(() -> super.createArtifactWithMetadata(groupId, artifactId, version, artifactType, content, metaData));
        this.limitsService.artifactCreated();
        return dto;
    }

    @Override
    public ArtifactMetaDataDto updateArtifact(String groupId, String artifactId, String version, ArtifactType artifactType, ContentHandle content) throws ArtifactNotFoundException, RegistryStorageException {
        ArtifactMetaDataDto dto = this.withLimitsCheck(() -> this.limitsService.canCreateArtifactVersion(groupId, artifactId, null)).execute(() -> super.updateArtifact(groupId, artifactId, version, artifactType, content));
        this.limitsService.artifactVersionCreated(groupId, artifactId);
        return dto;
    }

    @Override
    public ArtifactMetaDataDto updateArtifactWithMetadata(String groupId, String artifactId, String version, ArtifactType artifactType, ContentHandle content, EditableArtifactMetaDataDto metaData) throws ArtifactNotFoundException, RegistryStorageException {
        ArtifactMetaDataDto dto = this.withLimitsCheck(() -> this.limitsService.canCreateArtifactVersion(groupId, artifactId, metaData)).execute(() -> super.updateArtifactWithMetadata(groupId, artifactId, version, artifactType, content, metaData));
        this.limitsService.artifactVersionCreated(groupId, artifactId);
        return dto;
    }

    @Override
    public void updateArtifactMetaData(String groupId, String artifactId, EditableArtifactMetaDataDto metaData) throws ArtifactNotFoundException, RegistryStorageException {
        this.withLimitsCheck(() -> this.limitsService.checkMetaData(metaData)).execute(() -> {
            super.updateArtifactMetaData(groupId, artifactId, metaData);
            return null;
        });
    }

    @Override
    public void updateArtifactVersionMetaData(String groupId, String artifactId, String version, EditableArtifactMetaDataDto metaData) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        this.withLimitsCheck(() -> this.limitsService.checkMetaData(metaData)).execute(() -> {
            super.updateArtifactVersionMetaData(groupId, artifactId, version, metaData);
            return null;
        });
    }

    @Override
    public List<String> deleteArtifact(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        List<String> ids = super.deleteArtifact(groupId, artifactId);
        this.limitsService.artifactDeleted();
        return ids;
    }

    @Override
    public void deleteArtifacts(String groupId) throws RegistryStorageException {
        super.deleteArtifacts(groupId);
        this.limitsService.artifactDeleted();
    }

    @Override
    public void deleteArtifactVersion(String groupId, String artifactId, String version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        super.deleteArtifactVersion(groupId, artifactId, version);
        this.limitsService.artifactVersionDeleted(groupId, artifactId);
    }

    public ActionProvider withLimitsCheck(final LimitsChecker checker) {
        return new ActionProvider(){

            @Override
            public <T> T execute(LimitedAction<T> action) throws RegistryException {
                LimitsCheckResult r = (LimitsCheckResult)checker.get();
                if (r.isAllowed()) {
                    Object result = action.get();
                    if (result instanceof CompletionStage) {
                        result = RegistryStorageLimitsEnforcer.this.threadContext.withContextCapture((CompletionStage)result);
                    }
                    return result;
                }
                throw new LimitExceededException(r.getMessage());
            }
        };
    }

    @FunctionalInterface
    private static interface ActionProvider {
        public <T> T execute(LimitedAction<T> var1) throws RegistryException;
    }

    @FunctionalInterface
    private static interface LimitedAction<T> {
        public T get() throws RegistryException;
    }

    @FunctionalInterface
    private static interface LimitsChecker
    extends Supplier<LimitsCheckResult> {
    }
}

