/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.mt.limits;

import io.apicurio.multitenant.api.datamodel.RegistryTenant;
import io.apicurio.multitenant.api.datamodel.ResourceType;
import io.apicurio.multitenant.api.datamodel.TenantResource;
import io.apicurio.registry.mt.MultitenancyProperties;
import io.apicurio.registry.mt.TenantContext;
import io.apicurio.registry.mt.limits.TenantLimitsConfiguration;
import io.quarkus.runtime.StartupEvent;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class TenantLimitsConfigurationService {
    @Inject
    Logger logger;
    @Inject
    @ConfigProperty(defaultValue="30000", name="registry.limits.config.cache.check-period")
    Long limitsCheckPeriod;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-total-schemas")
    Long defaultMaxTotalSchemas;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-artifacts")
    Long defaultMaxArtifacts;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-versions-per-artifact")
    Long defaultMaxVersionsPerArtifact;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-artifact-properties")
    Long defaultMaxArtifactProperties;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-property-key-size")
    Long defaultMaxPropertyKeyBytesSize;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-property-value-size")
    Long defaultMaxPropertyValueBytesSize;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-artifact-lables")
    Long defaultMaxArtifactLabels;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-label-size")
    Long defaultMaxLabelBytesSize;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-name-length")
    Long defaultMaxNameLength;
    @Inject
    @ConfigProperty(defaultValue="-1", name="registry.limits.config.max-description-length")
    Long defaultMaxDescriptionLength;
    @Inject
    TenantContext tenantContext;
    @Inject
    MultitenancyProperties mtProperties;
    private boolean isConfigured = true;
    private TenantLimitsConfiguration defaultLimitsConfiguration;

    public void onStart(@Observes StartupEvent ev) {
        if (!this.mtProperties.isMultitenancyEnabled() && this.defaultMaxTotalSchemas < 0L && this.defaultMaxArtifacts < 0L && this.defaultMaxVersionsPerArtifact < 0L && this.defaultMaxArtifactProperties < 0L && this.defaultMaxPropertyKeyBytesSize < 0L && this.defaultMaxPropertyValueBytesSize < 0L && this.defaultMaxArtifactLabels < 0L && this.defaultMaxLabelBytesSize < 0L && this.defaultMaxNameLength < 0L && this.defaultMaxDescriptionLength < 0L) {
            this.isConfigured = false;
        }
        TenantLimitsConfiguration c = new TenantLimitsConfiguration();
        c.setMaxTotalSchemas(this.defaultMaxTotalSchemas);
        c.setMaxArtifacts(this.defaultMaxArtifacts);
        c.setMaxVersionsPerArtifact(this.defaultMaxVersionsPerArtifact);
        c.setMaxArtifactProperties(this.defaultMaxArtifactProperties);
        c.setMaxPropertyKeyBytesSize(this.defaultMaxPropertyKeyBytesSize);
        c.setMaxPropertyValueBytesSize(this.defaultMaxPropertyValueBytesSize);
        c.setMaxArtifactLabels(this.defaultMaxArtifactLabels);
        c.setMaxLabelBytesSize(this.defaultMaxLabelBytesSize);
        c.setMaxNameLength(this.defaultMaxNameLength);
        c.setMaxDescriptionLength(this.defaultMaxDescriptionLength);
        this.defaultLimitsConfiguration = c;
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }

    public TenantLimitsConfiguration defaultConfigurationTenant() {
        return this.defaultLimitsConfiguration;
    }

    public TenantLimitsConfiguration fromTenantMetadata(RegistryTenant tenantMetadata) {
        TenantLimitsConfiguration c = new TenantLimitsConfiguration();
        if (tenantMetadata.getResources() == null || tenantMetadata.getResources().isEmpty()) {
            this.logger.debug("Tenant has no resources config, using default tenant limits config");
            return this.defaultLimitsConfiguration;
        }
        Map<ResourceType, TenantResource> config = tenantMetadata.getResources().stream().collect(Collectors.toMap(tr -> tr.getType(), tr -> tr));
        block12: for (ResourceType type : ResourceType.values()) {
            Long limit = Optional.ofNullable(config.get(type)).map(TenantResource::getLimit).orElse(null);
            switch (type) {
                case MAX_TOTAL_SCHEMAS_COUNT: {
                    c.setMaxTotalSchemas(limit == null ? this.defaultMaxTotalSchemas : limit);
                    continue block12;
                }
                case MAX_ARTIFACTS_COUNT: {
                    c.setMaxArtifacts(limit == null ? this.defaultMaxArtifacts : limit);
                    continue block12;
                }
                case MAX_VERSIONS_PER_ARTIFACT_COUNT: {
                    c.setMaxVersionsPerArtifact(limit == null ? this.defaultMaxVersionsPerArtifact : limit);
                    continue block12;
                }
                case MAX_ARTIFACT_PROPERTIES_COUNT: {
                    c.setMaxArtifactProperties(limit == null ? this.defaultMaxArtifactProperties : limit);
                    continue block12;
                }
                case MAX_PROPERTY_KEY_SIZE_BYTES: {
                    c.setMaxPropertyKeyBytesSize(limit == null ? this.defaultMaxPropertyKeyBytesSize : limit);
                    continue block12;
                }
                case MAX_PROPERTY_VALUE_SIZE_BYTES: {
                    c.setMaxPropertyValueBytesSize(limit == null ? this.defaultMaxPropertyValueBytesSize : limit);
                    continue block12;
                }
                case MAX_ARTIFACT_LABELS_COUNT: {
                    c.setMaxArtifactLabels(limit == null ? this.defaultMaxArtifactLabels : limit);
                    continue block12;
                }
                case MAX_LABEL_SIZE_BYTES: {
                    c.setMaxLabelBytesSize(limit == null ? this.defaultMaxLabelBytesSize : limit);
                    continue block12;
                }
                case MAX_ARTIFACT_NAME_LENGTH_CHARS: {
                    c.setMaxNameLength(limit == null ? this.defaultMaxNameLength : limit);
                    continue block12;
                }
                case MAX_ARTIFACT_DESCRIPTION_LENGTH_CHARS: {
                    c.setMaxDescriptionLength(limit == null ? this.defaultMaxDescriptionLength : limit);
                    continue block12;
                }
                default: {
                    this.logger.error("Resource Type unhandled " + type.name());
                }
            }
        }
        return c;
    }
}

