/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.mt.limits;

import io.apicurio.registry.mt.TenantContext;
import io.apicurio.registry.mt.limits.LimitsCheckResult;
import io.apicurio.registry.mt.limits.TenantLimitsConfiguration;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.metrics.StorageMetricsStore;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Function;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class TenantLimitsService {
    private static final String MAX_TOTAL_SCHEMAS_EXCEEDED_MSG = "Maximum number of artifact versions exceeded";
    private static final String MAX_ARTIFACTS_EXCEEDED_MSG = "Maximum number of artifacts exceeded";
    private static final String MAX_VERSIONS_PER_ARTIFACT_EXCEEDED_MSG = "Maximum number of versions exceeded for this artifact";
    private static final String MAX_NAME_LENGTH_EXCEEDED_MSG = "Maximum artifact name lenght exceeded";
    private static final String MAX_DESC_LENGTH_EXCEEDED_MSG = "Maximum artifact description lenght exceeded";
    private static final String MAX_LABELS_EXCEEDED_MSG = "Maximum number of labels exceeded for this artifact";
    private static final String MAX_LABEL_SIZE_EXCEEDED_MSG = "Maximum label size exceeded";
    private static final String MAX_PROPERTIES_EXCEEDED_MSG = "Maximum number of properties exceeded for this artifact";
    private static final String MAX_PROP_KEY_SIZE_EXCEEDED_MSG = "Maximum property key size exceeded";
    private static final String MAX_PROP_VALUE_SIZE_EXCEEDED_MSG = "Maximum property value size exceeded";
    @Inject
    Logger log;
    @Inject
    TenantContext tenantContext;
    @Inject
    StorageMetricsStore storageMetricsStore;

    private LimitsCheckResult checkTotalSchemas() {
        if (this.isLimitDisabled(TenantLimitsConfiguration::getMaxTotalSchemas)) {
            return LimitsCheckResult.ok();
        }
        long currentTotalSchemas = this.storageMetricsStore.getOrInitializeTotalSchemasCounter();
        if (currentTotalSchemas < this.tenantContext.limitsConfig().getMaxTotalSchemas()) {
            return LimitsCheckResult.ok();
        }
        this.log.debug("Limit reached, current total schemas {} , max total schemas {}", (Object)currentTotalSchemas, (Object)this.tenantContext.limitsConfig().getMaxTotalSchemas());
        return LimitsCheckResult.disallowed(MAX_TOTAL_SCHEMAS_EXCEEDED_MSG);
    }

    public LimitsCheckResult canCreateArtifact(EditableArtifactMetaDataDto meta) {
        LimitsCheckResult mr = this.checkMetaData(meta);
        if (!mr.isAllowed()) {
            return mr;
        }
        LimitsCheckResult tsr = this.checkTotalSchemas();
        if (!tsr.isAllowed()) {
            return tsr;
        }
        if (this.isLimitDisabled(TenantLimitsConfiguration::getMaxArtifacts)) {
            return LimitsCheckResult.ok();
        }
        long currentArtifacts = this.storageMetricsStore.getOrInitializeArtifactsCounter();
        if (currentArtifacts < this.tenantContext.limitsConfig().getMaxArtifacts()) {
            return LimitsCheckResult.ok();
        }
        this.log.debug("Limit reached, current artifacts {} , max artifacts allowed {}", (Object)currentArtifacts, (Object)this.tenantContext.limitsConfig().getMaxArtifacts());
        return LimitsCheckResult.disallowed(MAX_ARTIFACTS_EXCEEDED_MSG);
    }

    public LimitsCheckResult canCreateArtifactVersion(String groupId, String artifactId, EditableArtifactMetaDataDto meta) {
        LimitsCheckResult mr = this.checkMetaData(meta);
        if (!mr.isAllowed()) {
            return mr;
        }
        LimitsCheckResult tsr = this.checkTotalSchemas();
        if (!tsr.isAllowed()) {
            return tsr;
        }
        if (this.isLimitDisabled(TenantLimitsConfiguration::getMaxVersionsPerArtifact)) {
            return LimitsCheckResult.ok();
        }
        long currentArtifactVersions = this.storageMetricsStore.getOrInitializeArtifactVersionsCounter(groupId, artifactId);
        if (currentArtifactVersions < this.tenantContext.limitsConfig().getMaxVersionsPerArtifact()) {
            return LimitsCheckResult.ok();
        }
        this.log.debug("Limit reached, current versions per artifact for artifact {}/{} {} , max versions per artifacts allowed {}", new Object[]{groupId, artifactId, currentArtifactVersions, this.tenantContext.limitsConfig().getMaxVersionsPerArtifact()});
        return LimitsCheckResult.disallowed(MAX_VERSIONS_PER_ARTIFACT_EXCEEDED_MSG);
    }

    public void artifactCreated() {
        this.storageMetricsStore.incrementTotalSchemasCounter();
        this.storageMetricsStore.incrementArtifactsCounter();
    }

    public void artifactVersionCreated(String groupId, String artifactId) {
        this.storageMetricsStore.incrementTotalSchemasCounter();
        this.storageMetricsStore.incrementArtifactVersionsCounter(groupId, artifactId);
    }

    public void artifactDeleted() {
        this.storageMetricsStore.resetTotalSchemasCounter();
        this.storageMetricsStore.resetArtifactsCounter();
    }

    public void artifactVersionDeleted(String groupId, String artifactId) {
        this.storageMetricsStore.resetTotalSchemasCounter();
        this.storageMetricsStore.resetArtifactVersionsCounter(groupId, artifactId);
    }

    public LimitsCheckResult checkMetaData(EditableArtifactMetaDataDto meta) {
        if (meta == null || this.tenantContext.limitsConfig() == null) {
            return LimitsCheckResult.ok();
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (meta.getName() != null && this.isLimitEnabled(TenantLimitsConfiguration::getMaxNameLength) && (long)meta.getName().length() > this.tenantContext.limitsConfig().getMaxNameLength()) {
            errorMessages.add(MAX_NAME_LENGTH_EXCEEDED_MSG);
        }
        if (meta.getDescription() != null && this.isLimitEnabled(TenantLimitsConfiguration::getMaxDescriptionLength) && (long)meta.getDescription().length() > this.tenantContext.limitsConfig().getMaxDescriptionLength()) {
            errorMessages.add(MAX_DESC_LENGTH_EXCEEDED_MSG);
        }
        if (meta.getLabels() != null) {
            if (this.isLimitEnabled(TenantLimitsConfiguration::getMaxArtifactLabels) && (long)meta.getLabels().size() > this.tenantContext.limitsConfig().getMaxArtifactLabels()) {
                errorMessages.add(MAX_LABELS_EXCEEDED_MSG);
            } else if (this.isLimitEnabled(TenantLimitsConfiguration::getMaxLabelBytesSize)) {
                meta.getLabels().forEach(l -> {
                    if ((long)l.getBytes(StandardCharsets.UTF_8).length > this.tenantContext.limitsConfig().getMaxLabelBytesSize()) {
                        errorMessages.add(MAX_LABEL_SIZE_EXCEEDED_MSG);
                    }
                });
            }
        }
        if (meta.getProperties() != null) {
            if (this.isLimitEnabled(TenantLimitsConfiguration::getMaxArtifactProperties) && (long)meta.getProperties().size() > this.tenantContext.limitsConfig().getMaxArtifactProperties()) {
                errorMessages.add(MAX_PROPERTIES_EXCEEDED_MSG);
            } else if (this.isLimitEnabled(TenantLimitsConfiguration::getMaxPropertyKeyBytesSize) || this.isLimitEnabled(TenantLimitsConfiguration::getMaxPropertyValueBytesSize)) {
                meta.getProperties().entrySet().forEach(e -> {
                    if (this.isLimitEnabled(TenantLimitsConfiguration::getMaxPropertyKeyBytesSize) && (long)((String)e.getKey()).length() > this.tenantContext.limitsConfig().getMaxPropertyKeyBytesSize()) {
                        errorMessages.add(MAX_PROP_KEY_SIZE_EXCEEDED_MSG);
                    }
                    if (this.isLimitEnabled(TenantLimitsConfiguration::getMaxPropertyValueBytesSize) && (long)((String)e.getValue()).length() > this.tenantContext.limitsConfig().getMaxPropertyValueBytesSize()) {
                        errorMessages.add(MAX_PROP_VALUE_SIZE_EXCEEDED_MSG);
                    }
                });
            }
        }
        if (errorMessages.isEmpty()) {
            return LimitsCheckResult.ok();
        }
        return LimitsCheckResult.disallowed(String.join((CharSequence)", ", errorMessages));
    }

    private boolean isLimitEnabled(Function<TenantLimitsConfiguration, Long> limitGetter) {
        Long limit;
        return this.tenantContext.limitsConfig() != null && (limit = limitGetter.apply(this.tenantContext.limitsConfig())) != null && limit >= 0L;
    }

    private boolean isLimitDisabled(Function<TenantLimitsConfiguration, Long> limitGetter) {
        return !this.isLimitEnabled(limitGetter);
    }
}

