/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.multitenant.api.datamodel.TenantStatusValue;
import io.apicurio.registry.mt.MultitenancyProperties;
import io.apicurio.registry.mt.TenantContext;
import io.apicurio.registry.mt.TenantIdResolver;
import io.apicurio.registry.services.DisabledApisMatcherService;
import io.apicurio.registry.services.http.ErrorHttpResponse;
import io.apicurio.registry.services.http.RegistryExceptionMapperService;
import java.io.IOException;
import java.io.OutputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

@ApplicationScoped
public class RegistryApplicationServletFilter
implements Filter {
    private ObjectMapper mapper;
    @Inject
    Logger log;
    @Inject
    MultitenancyProperties mtProperties;
    @Inject
    TenantIdResolver tenantIdResolver;
    @Inject
    TenantContext tenantContext;
    @Inject
    DisabledApisMatcherService disabledApisMatcherService;
    @Inject
    RegistryExceptionMapperService exceptionMapper;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        StringBuilder rewriteContext = new StringBuilder();
        HttpServletRequest req = (HttpServletRequest)request;
        String requestURI = req.getRequestURI();
        if (requestURI != null) {
            boolean tenantResolved = false;
            try {
                tenantResolved = this.tenantIdResolver.resolveTenantId(requestURI, headerName -> req.getHeader(headerName), () -> req.getServerName(), tenantId -> {
                    String actualUri = requestURI.substring(this.tenantIdResolver.tenantPrefixLength((String)tenantId));
                    if (actualUri.length() == 0) {
                        actualUri = "/";
                    }
                    this.log.debug("tenantId[{}] Rewriting request {} to {}", new Object[]{tenantId, requestURI, actualUri});
                    rewriteContext.append(actualUri);
                });
            }
            catch (Throwable e) {
                ErrorHttpResponse res = this.exceptionMapper.mapException(e);
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.reset();
                httpResponse.setStatus(res.getStatus());
                httpResponse.setContentType("application/json");
                this.getMapper().writeValue((OutputStream)httpResponse.getOutputStream(), (Object)res.getError());
                this.tenantContext.clearContext();
                return;
            }
            boolean rewriteRequest = tenantResolved && rewriteContext.length() != 0;
            String evaluatedURI = requestURI;
            if (rewriteRequest) {
                evaluatedURI = rewriteContext.toString();
            }
            if (this.mtProperties.isMultitenancyEnabled() && this.disabledApisMatcherService.isApiRequest(evaluatedURI) && (!tenantResolved || this.tenantContext.getTenantStatus() != TenantStatusValue.READY)) {
                this.log.warn("Request {} is rejected because the tenant could not be found, and direct access to apis is disabled in a multitenant deployment", (Object)requestURI);
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.reset();
                httpResponse.setStatus(404);
                this.tenantContext.clearContext();
                return;
            }
            boolean disabled = this.disabledApisMatcherService.isDisabled(evaluatedURI);
            if (disabled) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.reset();
                httpResponse.setStatus(404);
                this.tenantContext.clearContext();
                return;
            }
            if (rewriteRequest) {
                RequestDispatcher dispatcher = req.getRequestDispatcher(rewriteContext.toString());
                dispatcher.forward((ServletRequest)req, response);
                this.log.debug("Cleaning tenant context");
                this.tenantContext.clearContext();
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private synchronized ObjectMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
            this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        return this.mapper;
    }
}

