/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v1;

import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.rest.Headers;
import io.apicurio.registry.rest.HeadersHack;
import io.apicurio.registry.rest.v1.ArtifactsResource;
import io.apicurio.registry.rest.v1.V1ApiUtil;
import io.apicurio.registry.rest.v1.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v1.beans.EditableMetaData;
import io.apicurio.registry.rest.v1.beans.IfExistsType;
import io.apicurio.registry.rest.v1.beans.Rule;
import io.apicurio.registry.rest.v1.beans.UpdateState;
import io.apicurio.registry.rest.v1.beans.VersionMetaData;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.InvalidArtifactIdException;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.VersionNotFoundException;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.dto.StoredArtifactDto;
import io.apicurio.registry.types.ArtifactMediaTypes;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.util.ArtifactIdGenerator;
import io.apicurio.registry.util.ArtifactTypeUtil;
import io.apicurio.registry.util.ContentTypeUtil;
import io.apicurio.registry.util.VersionUtil;
import io.apicurio.registry.utils.ArtifactIdValidator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.interceptor.Interceptors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
@Deprecated
public class ArtifactsResourceImpl
implements ArtifactsResource,
Headers {
    private static final String EMPTY_CONTENT_ERROR_MESSAGE = "Empty content is not allowed.";
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RulesService rulesService;
    @Inject
    ArtifactIdGenerator idGenerator;
    @Context
    HttpServletRequest request;
    private static final int GET_ARTIFACT_IDS_LIMIT = 10000;

    private String getContentType() {
        return this.request.getContentType();
    }

    private ArtifactMetaData handleIfExists(ArtifactType artifactType, String artifactId, IfExistsType ifExists, ContentHandle content, String ct, boolean canonical) {
        ArtifactMetaData artifactMetaData = this.getArtifactMetaData(artifactId);
        if (ifExists == null) {
            ifExists = IfExistsType.FAIL;
        }
        switch (ifExists) {
            case UPDATE: {
                return this.updateArtifactInternal(artifactId, artifactType, content, ct);
            }
            case RETURN: {
                return artifactMetaData;
            }
            case RETURN_OR_UPDATE: {
                return this.handleIfExistsReturnOrUpdate(artifactId, artifactType, content, ct, canonical);
            }
        }
        throw new ArtifactAlreadyExistsException(null, artifactId);
    }

    private ArtifactMetaData handleIfExistsReturnOrUpdate(String artifactId, ArtifactType artifactType, ContentHandle content, String ct, boolean canonical) {
        try {
            ArtifactVersionMetaDataDto mdDto = this.storage.getArtifactVersionMetaData(null, artifactId, canonical, content);
            ArtifactMetaData md = V1ApiUtil.dtoToMetaData(artifactId, artifactType, mdDto);
            return md;
        }
        catch (ArtifactNotFoundException artifactNotFoundException) {
            return this.updateArtifactInternal(artifactId, artifactType, content, ct);
        }
    }

    public void checkIfDeprecated(Supplier<ArtifactState> stateSupplier, String artifactId, String version, Response.ResponseBuilder builder) {
        HeadersHack.checkIfDeprecated(stateSupplier, null, artifactId, version, builder);
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public void updateArtifactState(String artifactId, UpdateState data) {
        Objects.requireNonNull(artifactId);
        Objects.requireNonNull(data.getState());
        this.storage.updateArtifactState(null, artifactId, data.getState());
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public List<String> listArtifacts() {
        return new ArrayList<String>(this.storage.getArtifactIds(10000));
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public void updateArtifactVersionState(String artifactId, Integer version, UpdateState data) {
        Objects.requireNonNull(artifactId);
        Objects.requireNonNull(data.getState());
        Objects.requireNonNull(version);
        this.storage.updateArtifactState(null, artifactId, VersionUtil.toString(version), data.getState());
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public void testUpdateArtifact(String artifactId, ArtifactType xRegistryArtifactType, InputStream data) {
        Objects.requireNonNull(artifactId);
        ContentHandle content = ContentHandle.create(data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        String ct = this.getContentType();
        if (ContentTypeUtil.isApplicationYaml(ct)) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        ArtifactType artifactType = ArtifactTypeUtil.determineArtifactType(content, xRegistryArtifactType, ct);
        this.rulesService.applyRules(null, artifactId, artifactType, content, RuleApplicationType.UPDATE);
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Write)
    public ArtifactMetaData createArtifact(ArtifactType xRegistryArtifactType, String xRegistryArtifactId, IfExistsType ifExists, Boolean canonical, InputStream data) {
        ContentHandle content = ContentHandle.create(data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        boolean fcanonical = canonical == null ? Boolean.FALSE : canonical;
        String ct = this.getContentType();
        try {
            String artifactId = xRegistryArtifactId;
            if (artifactId == null || artifactId.trim().isEmpty()) {
                artifactId = this.idGenerator.generate();
            } else if (!ArtifactIdValidator.isArtifactIdAllowed((String)artifactId)) {
                throw new InvalidArtifactIdException("Character % and non ASCII characters are not allowed in artifact IDs.");
            }
            if (ContentTypeUtil.isApplicationYaml(ct)) {
                content = ContentTypeUtil.yamlToJson(content);
            }
            ArtifactType artifactType = ArtifactTypeUtil.determineArtifactType(content, xRegistryArtifactType, ct);
            this.rulesService.applyRules(null, artifactId, artifactType, content, RuleApplicationType.CREATE);
            String finalArtifactId = artifactId;
            ArtifactMetaDataDto amd = this.storage.createArtifact(null, artifactId, null, artifactType, content);
            return V1ApiUtil.dtoToMetaData(finalArtifactId, artifactType, amd);
        }
        catch (ArtifactAlreadyExistsException ex) {
            return this.handleIfExists(xRegistryArtifactType, xRegistryArtifactId, ifExists, content, ct, fcanonical);
        }
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public Response getLatestArtifact(String artifactId) {
        ArtifactMetaDataDto metaData = this.storage.getArtifactMetaData(null, artifactId);
        if (ArtifactState.DISABLED.equals((Object)metaData.getState())) {
            throw new ArtifactNotFoundException(null, artifactId);
        }
        StoredArtifactDto artifact = this.storage.getArtifact(null, artifactId);
        MediaType contentType = ArtifactMediaTypes.JSON;
        if (metaData.getType() == ArtifactType.PROTOBUF) {
            contentType = ArtifactMediaTypes.PROTO;
        }
        if (metaData.getType() == ArtifactType.GRAPHQL) {
            contentType = ArtifactMediaTypes.GRAPHQL;
        }
        if (metaData.getType() == ArtifactType.WSDL || metaData.getType() == ArtifactType.XSD || metaData.getType() == ArtifactType.XML) {
            contentType = ArtifactMediaTypes.XML;
        }
        Response.ResponseBuilder builder = Response.ok((Object)artifact.getContent(), (MediaType)contentType);
        this.checkIfDeprecated(metaData::getState, artifactId, metaData.getVersion(), builder);
        return builder.build();
    }

    private ArtifactMetaData updateArtifactInternal(String artifactId, ArtifactType xRegistryArtifactType, ContentHandle content, String ct) {
        Objects.requireNonNull(artifactId);
        if (ContentTypeUtil.isApplicationYaml(ct)) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        ArtifactType artifactType = ArtifactTypeUtil.determineArtifactType(content, xRegistryArtifactType, ct);
        this.rulesService.applyRules(null, artifactId, artifactType, content, RuleApplicationType.UPDATE);
        ArtifactMetaDataDto dto = this.storage.updateArtifact(null, artifactId, null, artifactType, content);
        return V1ApiUtil.dtoToMetaData(artifactId, artifactType, dto);
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public ArtifactMetaData updateArtifact(String artifactId, ArtifactType xRegistryArtifactType, InputStream data) {
        ContentHandle content = ContentHandle.create(data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        return this.updateArtifactInternal(artifactId, xRegistryArtifactType, content, this.getContentType());
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public void deleteArtifact(String artifactId) {
        this.storage.deleteArtifact(null, artifactId);
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public List<Long> listArtifactVersions(String artifactId) {
        List<String> versions = this.storage.getArtifactVersions(null, artifactId);
        return versions.stream().map(vstr -> VersionUtil.toLong(vstr)).collect(Collectors.toList());
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public VersionMetaData createArtifactVersion(String artifactId, ArtifactType xRegistryArtifactType, InputStream data) {
        Objects.requireNonNull(artifactId);
        ContentHandle content = ContentHandle.create(data);
        if (content.bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        String ct = this.getContentType();
        if (ContentTypeUtil.isApplicationYaml(ct)) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        ArtifactType artifactType = ArtifactTypeUtil.determineArtifactType(content, xRegistryArtifactType, ct);
        this.rulesService.applyRules(null, artifactId, artifactType, content, RuleApplicationType.UPDATE);
        ArtifactMetaDataDto amd = this.storage.updateArtifact(null, artifactId, null, artifactType, content);
        return V1ApiUtil.dtoToVersionMetaData(artifactId, artifactType, amd);
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public Response getArtifactVersion(String artifactId, Integer version) {
        String sversion = VersionUtil.toString(version);
        ArtifactVersionMetaDataDto metaData = this.storage.getArtifactVersionMetaData(null, artifactId, sversion);
        if (ArtifactState.DISABLED.equals((Object)metaData.getState())) {
            throw new VersionNotFoundException(null, artifactId, sversion);
        }
        StoredArtifactDto artifact = this.storage.getArtifactVersion(null, artifactId, sversion);
        MediaType contentType = ArtifactMediaTypes.JSON;
        if (metaData.getType() == ArtifactType.PROTOBUF) {
            contentType = ArtifactMediaTypes.PROTO;
        }
        if (metaData.getType() == ArtifactType.GRAPHQL) {
            contentType = ArtifactMediaTypes.GRAPHQL;
        }
        if (metaData.getType() == ArtifactType.WSDL || metaData.getType() == ArtifactType.XSD || metaData.getType() == ArtifactType.XML) {
            contentType = ArtifactMediaTypes.XML;
        }
        Response.ResponseBuilder builder = Response.ok((Object)artifact.getContent(), (MediaType)contentType);
        this.checkIfDeprecated(metaData::getState, artifactId, sversion, builder);
        return builder.build();
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public List<RuleType> listArtifactRules(String artifactId) {
        return this.storage.getArtifactRules(null, artifactId);
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public void createArtifactRule(String artifactId, Rule data) {
        RuleConfigurationDto config = new RuleConfigurationDto();
        config.setConfiguration(data.getConfig());
        this.storage.createArtifactRule(null, artifactId, data.getType(), config);
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public void deleteArtifactRules(String artifactId) {
        this.storage.deleteArtifactRules(null, artifactId);
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public Rule getArtifactRuleConfig(String artifactId, RuleType rule) {
        RuleConfigurationDto dto = this.storage.getArtifactRule(null, artifactId, rule);
        Rule rval = new Rule();
        rval.setConfig(dto.getConfiguration());
        rval.setType(rule);
        return rval;
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public Rule updateArtifactRuleConfig(String artifactId, RuleType rule, Rule data) {
        RuleConfigurationDto dto = new RuleConfigurationDto(data.getConfig());
        this.storage.updateArtifactRule(null, artifactId, rule, dto);
        Rule rval = new Rule();
        rval.setType(rule);
        rval.setConfig(data.getConfig());
        return rval;
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public void deleteArtifactRule(String artifactId, RuleType rule) {
        this.storage.deleteArtifactRule(null, artifactId, rule);
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public ArtifactMetaData getArtifactMetaData(String artifactId) {
        ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(null, artifactId);
        return V1ApiUtil.dtoToMetaData(artifactId, dto.getType(), dto);
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public VersionMetaData getArtifactVersionMetaDataByContent(String artifactId, Boolean canonical, InputStream data) {
        ContentHandle content;
        if (canonical == null) {
            canonical = Boolean.FALSE;
        }
        if ((content = ContentHandle.create(data)).bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        if (ContentTypeUtil.isApplicationYaml(this.getContentType())) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        ArtifactVersionMetaDataDto dto = this.storage.getArtifactVersionMetaData(null, artifactId, canonical, content);
        return V1ApiUtil.dtoToVersionMetaData(artifactId, dto.getType(), dto);
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public void updateArtifactMetaData(String artifactId, EditableMetaData data) {
        EditableArtifactMetaDataDto dto = new EditableArtifactMetaDataDto();
        dto.setName(data.getName());
        dto.setDescription(data.getDescription());
        dto.setLabels(data.getLabels());
        dto.setProperties(data.getProperties());
        this.storage.updateArtifactMetaData(null, artifactId, dto);
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public VersionMetaData getArtifactVersionMetaData(String artifactId, Integer version) {
        ArtifactVersionMetaDataDto dto = this.storage.getArtifactVersionMetaData(null, artifactId, VersionUtil.toString(version));
        return V1ApiUtil.dtoToVersionMetaData(artifactId, dto.getType(), dto);
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public void updateArtifactVersionMetaData(String artifactId, Integer version, EditableMetaData data) {
        EditableArtifactMetaDataDto dto = new EditableArtifactMetaDataDto();
        dto.setName(data.getName());
        dto.setDescription(data.getDescription());
        dto.setLabels(data.getLabels());
        dto.setProperties(data.getProperties());
        this.storage.updateArtifactVersionMetaData(null, artifactId, VersionUtil.toString(version), dto);
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public void deleteArtifactVersionMetaData(String artifactId, Integer version) {
        this.storage.deleteArtifactVersionMetaData(null, artifactId, VersionUtil.toString(version));
    }
}

