/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v2;

import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.auth.RoleBasedAccessApiOperation;
import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.rest.MissingRequiredParameterException;
import io.apicurio.registry.rest.v2.AdminResource;
import io.apicurio.registry.rest.v2.beans.LogConfiguration;
import io.apicurio.registry.rest.v2.beans.NamedLogConfiguration;
import io.apicurio.registry.rest.v2.beans.RoleMapping;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.UpdateRole;
import io.apicurio.registry.rules.DefaultRuleDeletionException;
import io.apicurio.registry.rules.RulesProperties;
import io.apicurio.registry.services.LogConfigurationService;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.RuleNotFoundException;
import io.apicurio.registry.storage.dto.RoleMappingDto;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.impexp.EntityInputStream;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RoleType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.impexp.Entity;
import io.apicurio.registry.utils.impexp.EntityReader;
import io.apicurio.registry.utils.impexp.EntityWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.interceptor.Interceptors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.slf4j.Logger;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class AdminResourceImpl
implements AdminResource {
    @Inject
    Logger log;
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RulesProperties rulesProperties;
    @Inject
    LogConfigurationService logConfigService;

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public List<RuleType> listGlobalRules() {
        List<RuleType> rules = this.storage.getGlobalRules();
        List<RuleType> defaultRules = this.rulesProperties.getFilteredDefaultGlobalRules(rules);
        return Stream.concat(rules.stream(), defaultRules.stream()).sorted().collect(Collectors.toList());
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public void createGlobalRule(Rule data) {
        RuleConfigurationDto configDto = new RuleConfigurationDto();
        configDto.setConfiguration(data.getConfig());
        this.storage.createGlobalRule(data.getType(), configDto);
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public void deleteAllGlobalRules() {
        this.storage.deleteGlobalRules();
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public Rule getGlobalRuleConfig(RuleType rule) {
        RuleConfigurationDto dto;
        block2: {
            try {
                dto = this.storage.getGlobalRule(rule);
            }
            catch (RuleNotFoundException ruleNotFoundException) {
                dto = this.rulesProperties.getDefaultGlobalRuleConfiguration(rule);
                if (dto != null) break block2;
                throw ruleNotFoundException;
            }
        }
        Rule ruleBean = new Rule();
        ruleBean.setType(rule);
        ruleBean.setConfig(dto.getConfiguration());
        return ruleBean;
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public Rule updateGlobalRuleConfig(RuleType rule, Rule data) {
        RuleConfigurationDto configDto = new RuleConfigurationDto();
        configDto.setConfiguration(data.getConfig());
        try {
            this.storage.updateGlobalRule(rule, configDto);
        }
        catch (RuleNotFoundException ruleNotFoundException) {
            if (this.rulesProperties.isDefaultGlobalRuleConfigured(rule)) {
                this.storage.createGlobalRule(rule, configDto);
            }
            throw ruleNotFoundException;
        }
        Rule ruleBean = new Rule();
        ruleBean.setType(rule);
        ruleBean.setConfig(data.getConfig());
        return ruleBean;
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public void deleteGlobalRule(RuleType rule) {
        try {
            this.storage.deleteGlobalRule(rule);
        }
        catch (RuleNotFoundException ruleNotFoundException) {
            if (this.rulesProperties.isDefaultGlobalRuleConfigured(rule)) {
                throw new DefaultRuleDeletionException(rule);
            }
            throw ruleNotFoundException;
        }
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public NamedLogConfiguration getLogConfiguration(String logger) {
        return this.logConfigService.getLogConfiguration(logger);
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public List<NamedLogConfiguration> listLogConfigurations() {
        return this.logConfigService.listLogConfigurations();
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public NamedLogConfiguration removeLogConfiguration(String logger) {
        return this.logConfigService.removeLogLevelConfiguration(logger);
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public NamedLogConfiguration setLogConfiguration(String logger, LogConfiguration data) {
        if (data.getLevel() == null) {
            throw new MissingRequiredParameterException("logLevel");
        }
        return this.logConfigService.setLogLevel(logger, data.getLevel());
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public void importData(InputStream data) {
        final ZipInputStream zip = new ZipInputStream(data, StandardCharsets.UTF_8);
        final EntityReader reader = new EntityReader(zip);
        EntityInputStream stream = new EntityInputStream(){

            @Override
            public Entity nextEntity() throws IOException {
                try {
                    return reader.readEntity();
                }
                catch (Exception e) {
                    AdminResourceImpl.this.log.error("Error reading data from import ZIP file.", (Throwable)e);
                    return null;
                }
            }

            @Override
            public void close() throws IOException {
                zip.close();
            }
        };
        this.storage.importData(stream);
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public Response exportData() {
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                try {
                    ZipOutputStream zip = new ZipOutputStream(os, StandardCharsets.UTF_8);
                    EntityWriter writer = new EntityWriter(zip);
                    AtomicInteger errorCounter = new AtomicInteger(0);
                    AdminResourceImpl.this.storage.exportData(entity -> {
                        try {
                            writer.writeEntity(entity);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            errorCounter.incrementAndGet();
                        }
                        return null;
                    });
                    zip.flush();
                    zip.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        };
        return Response.ok((Object)stream).type("application/zip").build();
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    @RoleBasedAccessApiOperation
    public void createRoleMapping(RoleMapping data) {
        this.storage.createRoleMapping(data.getPrincipalId(), data.getRole().name());
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    @RoleBasedAccessApiOperation
    public List<RoleMapping> listRoleMappings() {
        List<RoleMappingDto> mappings = this.storage.getRoleMappings();
        return mappings.stream().map(dto -> AdminResourceImpl.dtoToRoleMapping(dto)).collect(Collectors.toList());
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    @RoleBasedAccessApiOperation
    public RoleMapping getRoleMapping(String principalId) {
        RoleMappingDto dto = this.storage.getRoleMapping(principalId);
        return AdminResourceImpl.dtoToRoleMapping(dto);
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    @RoleBasedAccessApiOperation
    public void updateRoleMapping(String principalId, UpdateRole data) {
        this.storage.updateRoleMapping(principalId, data.getRole().name());
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    @RoleBasedAccessApiOperation
    public void deleteRoleMapping(String principalId) {
        this.storage.deleteRoleMapping(principalId);
    }

    private static RoleMapping dtoToRoleMapping(RoleMappingDto dto) {
        RoleMapping mapping = new RoleMapping();
        mapping.setPrincipalId(dto.getPrincipalId());
        mapping.setRole(RoleType.valueOf((String)dto.getRole()));
        return mapping;
    }
}

