/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import io.apicurio.registry.ccompat.rest.error.UnprocessableEntityException;
import io.apicurio.registry.rules.compatibility.CompatibilityChecker;
import io.apicurio.registry.rules.compatibility.CompatibilityExecutionResult;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.SchemaValidator;
import org.apache.avro.SchemaValidatorBuilder;

public class AvroCompatibilityChecker
implements CompatibilityChecker {
    @Override
    public CompatibilityExecutionResult testCompatibility(CompatibilityLevel compatibilityLevel, List<String> existingSchemaStrings, String proposedSchemaString) {
        Objects.requireNonNull(compatibilityLevel, "compatibilityLevel MUST NOT be null");
        Objects.requireNonNull(existingSchemaStrings, "existingSchemaStrings MUST NOT be null");
        Objects.requireNonNull(proposedSchemaString, "proposedSchemaString MUST NOT be null");
        SchemaValidator schemaValidator = this.validatorFor(compatibilityLevel);
        if (schemaValidator == null) {
            return CompatibilityExecutionResult.compatible();
        }
        List existingSchemas = existingSchemaStrings.stream().map(s -> new Schema.Parser().parse(s)).collect(Collectors.toList());
        Collections.reverse(existingSchemas);
        try {
            Schema toValidate = new Schema.Parser().parse(proposedSchemaString);
            schemaValidator.validate(toValidate, existingSchemas);
            return CompatibilityExecutionResult.compatible();
        }
        catch (SchemaValidationException e) {
            return CompatibilityExecutionResult.incompatible((Exception)((Object)e));
        }
        catch (SchemaParseException e) {
            throw new UnprocessableEntityException(e.getMessage());
        }
    }

    private SchemaValidator validatorFor(CompatibilityLevel compatibilityLevel) {
        switch (compatibilityLevel) {
            case BACKWARD: {
                return new SchemaValidatorBuilder().canReadStrategy().validateLatest();
            }
            case BACKWARD_TRANSITIVE: {
                return new SchemaValidatorBuilder().canReadStrategy().validateAll();
            }
            case FORWARD: {
                return new SchemaValidatorBuilder().canBeReadStrategy().validateLatest();
            }
            case FORWARD_TRANSITIVE: {
                return new SchemaValidatorBuilder().canBeReadStrategy().validateAll();
            }
            case FULL: {
                return new SchemaValidatorBuilder().mutualReadStrategy().validateLatest();
            }
            case FULL_TRANSITIVE: {
                return new SchemaValidatorBuilder().mutualReadStrategy().validateAll();
            }
        }
        return null;
    }
}

