/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import io.apicurio.registry.rules.compatibility.CompatibilityDifference;
import io.apicurio.registry.rules.compatibility.GenericCompatibilityDifference;
import java.util.Collections;
import java.util.Set;

public class CompatibilityExecutionResult {
    private final Set<CompatibilityDifference> incompatibleDifferences;

    private CompatibilityExecutionResult(Set<CompatibilityDifference> incompatibleDifferences) {
        this.incompatibleDifferences = incompatibleDifferences;
    }

    public boolean isCompatible() {
        return this.incompatibleDifferences == null || this.incompatibleDifferences.isEmpty();
    }

    public Set<CompatibilityDifference> getIncompatibleDifferences() {
        return this.incompatibleDifferences;
    }

    public static CompatibilityExecutionResult compatible() {
        return new CompatibilityExecutionResult(Collections.emptySet());
    }

    public static CompatibilityExecutionResult incompatible(Set<CompatibilityDifference> incompatibleDifferences) {
        return new CompatibilityExecutionResult(incompatibleDifferences);
    }

    public static CompatibilityExecutionResult incompatible(Exception e) {
        GenericCompatibilityDifference diff = new GenericCompatibilityDifference(e);
        return new CompatibilityExecutionResult(Collections.singleton(diff));
    }

    public static CompatibilityExecutionResult incompatible(String message) {
        GenericCompatibilityDifference diff = new GenericCompatibilityDifference(message);
        return new CompatibilityExecutionResult(Collections.singleton(diff));
    }
}

