/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import io.apicurio.registry.rules.compatibility.CompatibilityChecker;
import io.apicurio.registry.rules.compatibility.CompatibilityExecutionResult;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.apicurio.registry.rules.compatibility.protobuf.ProtobufCompatibilityCheckerLibrary;
import io.apicurio.registry.utils.protobuf.schema.ProtobufFile;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ProtobufCompatibilityChecker
implements CompatibilityChecker {
    @Override
    public CompatibilityExecutionResult testCompatibility(CompatibilityLevel compatibilityLevel, List<String> existingSchemas, String proposedSchema) {
        Objects.requireNonNull(compatibilityLevel, "compatibilityLevel MUST NOT be null");
        Objects.requireNonNull(existingSchemas, "existingSchemas MUST NOT be null");
        Objects.requireNonNull(proposedSchema, "proposedSchema MUST NOT be null");
        if (existingSchemas.isEmpty()) {
            return CompatibilityExecutionResult.compatible();
        }
        switch (compatibilityLevel) {
            case BACKWARD: {
                ProtobufFile fileBefore = new ProtobufFile(existingSchemas.get(existingSchemas.size() - 1));
                ProtobufFile fileAfter = new ProtobufFile(proposedSchema);
                ProtobufCompatibilityCheckerLibrary checker = new ProtobufCompatibilityCheckerLibrary(fileBefore, fileAfter);
                if (checker.validate()) {
                    return CompatibilityExecutionResult.compatible();
                }
                return CompatibilityExecutionResult.incompatible("The new version of the protobuf artifact is not backward compatible.");
            }
            case BACKWARD_TRANSITIVE: {
                ProtobufFile fileAfter = new ProtobufFile(proposedSchema);
                Iterator<String> iterator = existingSchemas.iterator();
                if (iterator.hasNext()) {
                    String existing = iterator.next();
                    ProtobufFile fileBefore = new ProtobufFile(existing);
                    ProtobufCompatibilityCheckerLibrary checker = new ProtobufCompatibilityCheckerLibrary(fileBefore, fileAfter);
                    if (checker.validate()) {
                        return CompatibilityExecutionResult.compatible();
                    }
                    return CompatibilityExecutionResult.incompatible("The new version of the protobuf artifact is not backward compatible.");
                }
                return CompatibilityExecutionResult.compatible();
            }
            case FORWARD: 
            case FORWARD_TRANSITIVE: 
            case FULL: 
            case FULL_TRANSITIVE: {
                throw new IllegalStateException("Compatibility level " + compatibilityLevel + " not supported for Protobuf schemas");
            }
        }
        return CompatibilityExecutionResult.compatible();
    }
}

