/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.RuleViolation;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.validity.ContentValidator;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.types.RuleType;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class ApicurioDataModelContentValidator
implements ContentValidator {
    @Override
    public void validate(ValidityLevel level, ContentHandle artifactContent) throws RuleViolationException {
        List problems;
        Document document = null;
        if (level == ValidityLevel.SYNTAX_ONLY || level == ValidityLevel.FULL) {
            try {
                document = Library.readDocumentFromJSONString((String)artifactContent.content());
            }
            catch (Exception e) {
                throw new RuleViolationException("Syntax violation for " + this.getDataModelType() + " artifact.", RuleType.VALIDITY, level.name(), e);
            }
        }
        if (level == ValidityLevel.FULL && !(problems = Library.validate((Node)document, null)).isEmpty()) {
            Set<RuleViolation> causes = problems.stream().map(problem -> new RuleViolation(problem.message, problem.nodePath.toString())).collect(Collectors.toSet());
            throw new RuleViolationException("The " + this.getDataModelType() + " artifact is not semantically valid. " + problems.size() + " problems found.", RuleType.VALIDITY, level.name(), causes);
        }
    }

    protected abstract String getDataModelType();
}

