/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.services.auth;

import io.apicurio.registry.services.auth.CredentialsHelper;
import io.apicurio.registry.services.auth.CustomAuthenticationMechanism;
import io.apicurio.rest.client.auth.OidcAuth;
import io.apicurio.rest.client.auth.exception.NotAuthorizedException;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Alternative
@Priority(value=1)
@ApplicationScoped
public class BasicAuthClientCredentialsMechanism
implements HttpAuthenticationMechanism {
    @Inject
    CustomAuthenticationMechanism customAuthenticationMechanism;
    @ConfigProperty(name="registry.auth.enabled")
    boolean authEnabled;
    @ConfigProperty(name="registry.auth.basic-auth-client-credentials.enabled")
    boolean fakeBasicAuthEnabled;
    @ConfigProperty(name="registry.auth.token.endpoint")
    String authServerUrl;

    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        if (this.authEnabled) {
            if (this.fakeBasicAuthEnabled) {
                Pair<String, String> clientCredentials = CredentialsHelper.extractCredentialsFromContext(context);
                if (null != clientCredentials) {
                    try {
                        return this.authenticateWithClientCredentials(clientCredentials, context, identityProviderManager);
                    }
                    catch (NotAuthorizedException ex) {
                        throw new AuthenticationFailedException();
                    }
                }
                return this.customAuthenticationMechanism.authenticate(context, identityProviderManager);
            }
            return this.customAuthenticationMechanism.authenticate(context, identityProviderManager);
        }
        return Uni.createFrom().nullItem();
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        return this.customAuthenticationMechanism.getChallenge(context);
    }

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.singleton(TokenAuthenticationRequest.class);
    }

    public HttpCredentialTransport getCredentialTransport() {
        return new HttpCredentialTransport(HttpCredentialTransport.Type.AUTHORIZATION, "bearer");
    }

    private Uni<SecurityIdentity> authenticateWithClientCredentials(Pair<String, String> clientCredentials, RoutingContext context, IdentityProviderManager identityProviderManager) {
        String jwtToken = new OidcAuth(this.authServerUrl, (String)clientCredentials.getLeft(), (String)clientCredentials.getRight()).authenticate();
        return identityProviderManager.authenticate((AuthenticationRequest)new TokenAuthenticationRequest((TokenCredential)new AccessTokenCredential(jwtToken, context)));
    }
}

