/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import io.apicurio.registry.storage.impl.sql.H2SqlStatements;
import io.apicurio.registry.storage.impl.sql.PostgreSQLSqlStatements;
import io.apicurio.registry.storage.impl.sql.SqlStatements;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class SqlStatementsProducer {
    @Inject
    Logger log;
    @ConfigProperty(name="quarkus.datasource.db-kind", defaultValue="postgresql")
    String databaseType;

    @Produces
    @ApplicationScoped
    public SqlStatements createSqlStatements() {
        this.log.debug("Creating an instance of ISqlStatements for DB: " + this.databaseType);
        if ("h2".equals(this.databaseType)) {
            return new H2SqlStatements();
        }
        if ("postgresql".equals(this.databaseType)) {
            return new PostgreSQLSqlStatements();
        }
        throw new RuntimeException("Unsupported database type: " + this.databaseType);
    }
}

