/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql.mappers;

import io.apicurio.registry.storage.impl.sql.SqlUtil;
import io.apicurio.registry.storage.impl.sql.jdb.RowMapper;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.impexp.GroupEntity;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Optional;

public class GroupEntityMapper
implements RowMapper<GroupEntity> {
    public static final GroupEntityMapper instance = new GroupEntityMapper();

    private GroupEntityMapper() {
    }

    @Override
    public GroupEntity map(ResultSet rs) throws SQLException {
        GroupEntity entity = new GroupEntity();
        entity.groupId = SqlUtil.denormalizeGroupId(rs.getString("groupId"));
        entity.description = rs.getString("description");
        String type = rs.getString("artifactsType");
        entity.artifactsType = type == null ? null : ArtifactType.valueOf((String)type);
        entity.createdBy = rs.getString("createdBy");
        entity.createdOn = rs.getTimestamp("createdOn").getTime();
        entity.modifiedBy = rs.getString("modifiedBy");
        entity.modifiedOn = Optional.ofNullable(rs.getTimestamp("modifiedOn")).map(Timestamp::getTime).orElse(0L);
        entity.properties = SqlUtil.deserializeProperties(rs.getString("properties"));
        return entity;
    }
}

