/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ui.servlets;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.auth.AuthConfig;
import io.apicurio.registry.ui.beans.ConfigJs;
import io.apicurio.registry.ui.config.UiConfigProperties;
import io.apicurio.registry.utils.StringUtil;
import io.quarkus.security.identity.SecurityIdentity;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConfigJsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1624928159818173418L;
    @Inject
    UiConfigProperties uiConfig;
    @Inject
    SecurityIdentity identity;
    @Inject
    AuthConfig authConfig;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String ct = "application/javascript; charset=" + StandardCharsets.UTF_8;
        response.setContentType(ct);
        JsonFactory f = new JsonFactory();
        try (JsonGenerator g = f.createGenerator((OutputStream)response.getOutputStream(), JsonEncoding.UTF8);){
            response.getOutputStream().write("var ApicurioRegistryConfig = ".getBytes("UTF-8"));
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            g.setCodec((ObjectCodec)mapper);
            g.useDefaultPrettyPrinter();
            ConfigJs config = new ConfigJs();
            config.artifacts.url = this.generateApiUrl(request);
            config.ui.contextPath = this.uiConfig.getUiContextPath();
            config.features.readOnly = this.uiConfig.isFeatureReadOnly();
            config.features.breadcrumbs = true;
            this.configureAuth(config);
            g.writeObject((Object)config);
            g.flush();
            response.getOutputStream().write(";".getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void configureAuth(ConfigJs config) {
        if (this.uiConfig.isKeycloakAuthEnabled()) {
            config.auth.type = "keycloakjs";
            config.auth.options = this.uiConfig.getKeycloakProperties();
            config.auth.rbacEnabled = this.authConfig.isRbacEnabled();
            config.auth.obacEnabled = this.authConfig.isObacEnabled();
            config.features.roleManagement = this.authConfig.isApplicationRbacEnabled();
        } else {
            config.auth.type = "none";
        }
    }

    private String generateApiUrl(HttpServletRequest request) {
        String apiRelativePath = "/apis/registry";
        try {
            String apiUrl = this.uiConfig.getApiUrl();
            if (!"_".equals(apiUrl) && !StringUtil.isEmpty((String)apiUrl)) {
                return apiUrl;
            }
            String url = this.resolveUrlFromXForwarded(request, apiRelativePath);
            if (url != null) {
                return url;
            }
            url = request.getRequestURL().toString();
            if ((url = new URI(url).resolve(apiRelativePath).toString()).startsWith("http:") && request.isSecure()) {
                url = url.replaceFirst("http", "https");
            }
            return url;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private String resolveUrlFromXForwarded(HttpServletRequest request, String path) {
        try {
            String fproto = request.getHeader("X-Forwarded-Proto");
            String fhost = request.getHeader("X-Forwarded-Host");
            if (!StringUtil.isEmpty((String)fproto) && !StringUtil.isEmpty((String)fhost)) {
                return new URI(fproto + "://" + fhost).resolve(path).toString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }
}

