/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jws.crypto;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import org.keycloak.common.util.Base64Url;
import org.keycloak.crypto.HashException;
import org.keycloak.crypto.JavaAlgorithm;

public class HashUtils {
    public static String oidcHash(String jwtAlgorithmName, String input) {
        byte[] inputBytes = input.getBytes(StandardCharsets.UTF_8);
        String javaAlgName = JavaAlgorithm.getJavaAlgorithmForHash(jwtAlgorithmName);
        byte[] hash = HashUtils.hash(javaAlgName, inputBytes);
        return HashUtils.encodeHashToOIDC(hash);
    }

    public static byte[] hash(String javaAlgorithmName, byte[] inputBytes) {
        try {
            MessageDigest md = MessageDigest.getInstance(javaAlgorithmName);
            md.update(inputBytes);
            return md.digest();
        }
        catch (Exception e) {
            throw new HashException("Error when creating token hash", e);
        }
    }

    public static String encodeHashToOIDC(byte[] hash) {
        int hashLength = hash.length / 2;
        byte[] hashInput = Arrays.copyOf(hash, hashLength);
        return Base64Url.encode((byte[])hashInput);
    }
}

