/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.multitenant.api.datamodel;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.apicurio.multitenant.api.datamodel.TenantResource;
import io.apicurio.multitenant.api.datamodel.TenantStatusValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"tenantId", "createdOn", "createdBy", "organizationId", "resources", "name", "description", "status"})
public class RegistryTenant {
    @JsonProperty(value="tenantId")
    @JsonPropertyDescription(value="Unique identifier of a tenant within a registry deployment")
    private String tenantId;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssZ", timezone="UTC")
    @JsonProperty(value="createdOn")
    @JsonPropertyDescription(value="Date when the tenant was created. ISO 8601 UTC timestamp.")
    private Date createdOn;
    @JsonProperty(value="createdBy")
    @JsonPropertyDescription(value="User that created the tenant")
    private String createdBy;
    @JsonProperty(value="organizationId")
    @JsonPropertyDescription(value="")
    private Object organizationId;
    @JsonProperty(value="resources")
    @JsonPropertyDescription(value="The list of resources that this tenant has available")
    private List<TenantResource> resources = new ArrayList<TenantResource>();
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name of the tenant.")
    private String name;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="The description of the tenant.")
    private String description;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="\"READY\": Tenant status when ready for use.\n\n\"TO_BE_DELETED\": Tenant status when marked to be deleted with all it's data.\n\n\"DELETED\": Tenant status after data deletion is finished.\n")
    private TenantStatusValue status;

    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="createdOn")
    public Date getCreatedOn() {
        return this.createdOn;
    }

    @JsonProperty(value="createdOn")
    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    @JsonProperty(value="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    @JsonProperty(value="createdBy")
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @JsonProperty(value="organizationId")
    public Object getOrganizationId() {
        return this.organizationId;
    }

    @JsonProperty(value="organizationId")
    public void setOrganizationId(Object organizationId) {
        this.organizationId = organizationId;
    }

    @JsonProperty(value="resources")
    public List<TenantResource> getResources() {
        return this.resources;
    }

    @JsonProperty(value="resources")
    public void setResources(List<TenantResource> resources) {
        this.resources = resources;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="status")
    public TenantStatusValue getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(TenantStatusValue status) {
        this.status = status;
    }
}

