/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.kafka;

import io.apicurio.registry.utils.ConcurrentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaUtil {
    private static final Logger log = LoggerFactory.getLogger(KafkaUtil.class);

    public static <T> T result(KafkaFuture<T> kf) {
        CompletionStage<T> cs = KafkaUtil.toCompletionStage(kf);
        return (T)ConcurrentUtil.result(cs);
    }

    public static <T> CompletionStage<T> toCompletionStage(KafkaFuture<T> kf) {
        CompletableFuture cf = new CompletableFuture();
        kf.whenComplete((v, t) -> {
            if (t != null) {
                cf.completeExceptionally((Throwable)t);
            } else {
                cf.complete(v);
            }
        });
        return cf;
    }

    public static void createTopics(Properties properties, Set<String> topicNames, Map<String, String> topicConfig) {
        try (Admin admin = Admin.create((Properties)properties);){
            KafkaUtil.createTopics(admin, topicNames, topicConfig);
        }
    }

    public static void createTopics(Properties properties, Set<String> topicNames) {
        KafkaUtil.createTopics(properties, topicNames, null);
    }

    public static void createTopics(Admin admin, Set<String> topicNames, Map<String, String> topicConfig) {
        ConcurrentUtil.result(KafkaUtil.createTopicsAsync(admin, topicNames, topicConfig));
    }

    public static void createTopics(Admin admin, Set<String> topicNames) {
        KafkaUtil.createTopics(admin, topicNames, null);
    }

    public static CompletionStage<Void> createTopicsAsync(Admin admin, Set<String> topicNames, Map<String, String> topicConfig) {
        ArrayList topicsToCreate = new ArrayList();
        return KafkaUtil.toCompletionStage(admin.listTopics().names()).thenCompose(topics -> {
            for (String topicName : topicNames) {
                KafkaUtil.createTopic(admin, topics, topicsToCreate, topicName, topicConfig);
            }
            return CompletableFuture.allOf(topicsToCreate.toArray(new CompletableFuture[0]));
        }).thenCompose(v -> {
            if (topicsToCreate.size() > 0) {
                return KafkaUtil.toCompletionStage(admin.createTopics((Collection)topicsToCreate.stream().map(ConcurrentUtil::result).collect(Collectors.toList())).all());
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private static void createTopic(Admin admin, Set<String> topics, List<CompletionStage<NewTopic>> topicsToCreate, String topicName, Map<String, String> topicConfig) {
        if (!topics.contains(topicName)) {
            KafkaFuture newTopicKF = admin.describeCluster().nodes().thenApply(nodes -> {
                HashMap<String, String> configs = new HashMap<String, String>();
                if (topicConfig != null) {
                    configs.putAll(topicConfig);
                }
                log.info("Creating new Kafka topic: {}", (Object)topicName);
                int replicationFactor = Math.min(3, nodes.size());
                if (configs.containsKey("replication.factor")) {
                    replicationFactor = Integer.parseInt((String)configs.get("replication.factor"));
                }
                int minimumInSyncReplicas = Math.max(replicationFactor - 1, 1);
                configs.putIfAbsent("min.insync.replicas", String.valueOf(minimumInSyncReplicas));
                return new NewTopic(topicName, 1, (short)replicationFactor).configs(configs);
            }).whenComplete((nt, t) -> log.info("Created new topic: {}", (Object)topicName, t));
            topicsToCreate.add(KafkaUtil.toCompletionStage(newTopicKF));
        }
    }
}

