/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.v3.models.Oas30Example;
import io.apicurio.datamodels.openapi.v3.models.Oas30Parameter;
import java.util.HashMap;
import java.util.Map;

public class DeleteAllParameterExamplesCommand
extends AbstractCommand {
    public NodePath _parameterPath;
    @JsonDeserialize(contentUsing=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Map<String, Object> _oldExamples;

    DeleteAllParameterExamplesCommand() {
    }

    DeleteAllParameterExamplesCommand(Oas30Parameter parameter) {
        this._parameterPath = Library.createNodePath(parameter);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteAllParameterExamplesCommand] Executing.", new Object[0]);
        if (this.isNullOrUndefined(document)) {
            LoggerCompat.debug("[DeleteAllParameterExamplesCommand] Could not execute the command, invalid argument.", new Object[0]);
            return;
        }
        if (this.isNullOrUndefined(this._parameterPath)) {
            LoggerCompat.debug("[DeleteAllParameterExamplesCommand] Could not execute the command, problem when unmarshalling.", new Object[0]);
            return;
        }
        Oas30Parameter parameter = (Oas30Parameter)this._parameterPath.resolve(document);
        if (this.isNullOrUndefined(parameter)) {
            LoggerCompat.debug("[DeleteAllParameterExamplesCommand] Parameter not found.", new Object[0]);
            return;
        }
        this._oldExamples = new HashMap<String, Object>();
        parameter.getExamples().forEach(e -> this._oldExamples.put(e.getName(), Library.writeNode((Node)((Object)e))));
        parameter.clearExamples();
    }

    @Override
    public void undo(Document document) {
        if (this.isNullOrUndefined(document)) {
            LoggerCompat.debug("[DeleteAllParameterExamplesCommand] Could not revert the command, invalid argument.", new Object[0]);
            return;
        }
        if (this.isNullOrUndefined(this._parameterPath)) {
            LoggerCompat.debug("[DeleteAllParameterExamplesCommand] Could not revert the command, problem when unmarshalling.", new Object[0]);
            return;
        }
        LoggerCompat.info("[DeleteAllParameterExamplesCommand] Reverting.", new Object[0]);
        Oas30Parameter parameter = (Oas30Parameter)this._parameterPath.resolve(document);
        if (this.isNullOrUndefined(parameter)) {
            LoggerCompat.info("[DeleteAllParameterExamplesCommand] No parameter found.", new Object[0]);
            return;
        }
        if (this.isNullOrUndefined(this._oldExamples)) {
            LoggerCompat.info("[DeleteAllExamplesCommand] Could not revert. Previous data is not available.", new Object[0]);
            return;
        }
        for (String k : this._oldExamples.keySet()) {
            Oas30Example example = parameter.createExample(k);
            Library.readNode(this._oldExamples.get(k), example);
            parameter.addExample(example);
        }
    }
}

