/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiSecurityScheme;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20NodeFactory;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.DocumentType;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityScheme;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30SecurityScheme;
import java.util.ArrayList;
import java.util.List;

public class DeleteAllSecuritySchemesCommand
extends AbstractCommand {
    @JsonDeserialize(contentUsing=MarshallCompat.NullableJsonNodeDeserializer.class)
    public List<Object> _oldSecuritySchemes;

    DeleteAllSecuritySchemesCommand() {
    }

    @Override
    public void execute(Document document) {
        Document doc;
        LoggerCompat.info("[DeleteAllSecuritySchemesCommand] Executing.", new Object[0]);
        this._oldSecuritySchemes = new ArrayList<Object>();
        if (document.getDocumentType() == DocumentType.openapi2) {
            doc = (Oas20Document)document;
            if (!this.isNullOrUndefined(doc.securityDefinitions)) {
                doc.securityDefinitions.getSecuritySchemes().forEach(scheme -> {
                    Object savedScheme = Library.writeNode(scheme);
                    JsonCompat.setPropertyString(savedScheme, "__name", scheme.getSchemeName());
                    this._oldSecuritySchemes.add(savedScheme);
                });
            }
            doc.securityDefinitions = null;
        }
        if (document.getDocumentType() == DocumentType.openapi3) {
            doc = (Oas30Document)document;
            if (!this.isNullOrUndefined(((Oas30Document)doc).components)) {
                ((Oas30Document)doc).components.getSecuritySchemes().forEach(arg_0 -> this.lambda$execute$1((Oas30Document)doc, arg_0));
            }
        }
        if (document.getDocumentType() == DocumentType.asyncapi2) {
            doc = (Aai20Document)document;
            if (!this.isNullOrUndefined(((Aai20Document)doc).components)) {
                ((Aai20Document)doc).components.getSecuritySchemesList().forEach(arg_0 -> this.lambda$execute$2((Aai20Document)doc, arg_0));
            }
        }
    }

    @Override
    public void undo(Document document) {
        Document doc;
        LoggerCompat.info("[DeleteAllSecuritySchemesCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldSecuritySchemes) || this._oldSecuritySchemes.size() == 0) {
            return;
        }
        if (document.getDocumentType() == DocumentType.openapi2) {
            doc = (Oas20Document)document;
            if (this.isNullOrUndefined(((Oas20Document)doc).securityDefinitions)) {
                ((Oas20Document)doc).securityDefinitions = ((Oas20Document)doc).createSecurityDefinitions();
            }
            this._oldSecuritySchemes.forEach(arg_0 -> DeleteAllSecuritySchemesCommand.lambda$undo$3((Oas20Document)doc, arg_0));
        }
        if (document.getDocumentType() == DocumentType.openapi3) {
            doc = (Oas30Document)document;
            if (this.isNullOrUndefined(((Oas30Document)doc).components)) {
                ((Oas30Document)doc).components = ((Oas30Document)doc).createComponents();
            }
            this._oldSecuritySchemes.forEach(arg_0 -> DeleteAllSecuritySchemesCommand.lambda$undo$4((Oas30Document)doc, arg_0));
        }
        if (document.getDocumentType() == DocumentType.asyncapi2) {
            doc = (Aai20Document)document;
            if (this.isNullOrUndefined(((Aai20Document)doc).components)) {
                ((Aai20Document)doc).components = ((Aai20Document)doc).createComponents();
            }
            Aai20NodeFactory nodeFactory = new Aai20NodeFactory();
            this._oldSecuritySchemes.forEach(arg_0 -> DeleteAllSecuritySchemesCommand.lambda$undo$5(nodeFactory, (Aai20Document)doc, arg_0));
        }
    }

    private static /* synthetic */ void lambda$undo$5(Aai20NodeFactory nodeFactory, Aai20Document doc, Object savedScheme) {
        String name = JsonCompat.consumePropertyString(savedScheme, "__name");
        AaiSecurityScheme scheme = nodeFactory.createSecurityScheme(doc.components, name);
        Library.readNode(savedScheme, scheme);
        doc.components.addSecurityScheme(name, scheme);
    }

    private static /* synthetic */ void lambda$undo$4(Oas30Document doc, Object savedScheme) {
        String name = JsonCompat.consumePropertyString(savedScheme, "__name");
        Oas30SecurityScheme scheme = doc.components.createSecurityScheme(name);
        Library.readNode(savedScheme, scheme);
        doc.components.addSecurityScheme(name, scheme);
    }

    private static /* synthetic */ void lambda$undo$3(Oas20Document doc, Object savedScheme) {
        String name = JsonCompat.consumePropertyString(savedScheme, "__name");
        Oas20SecurityScheme scheme = doc.securityDefinitions.createSecurityScheme(name);
        Library.readNode(savedScheme, scheme);
        doc.securityDefinitions.addSecurityScheme(name, scheme);
    }

    private /* synthetic */ void lambda$execute$2(Aai20Document doc, AaiSecurityScheme scheme) {
        Object savedScheme = Library.writeNode(scheme);
        JsonCompat.setPropertyString(savedScheme, "__name", scheme.getSchemeName());
        this._oldSecuritySchemes.add(savedScheme);
        doc.components.removeSecurityScheme(scheme.getSchemeName());
    }

    private /* synthetic */ void lambda$execute$1(Oas30Document doc, Oas30SecurityScheme scheme) {
        Object savedScheme = Library.writeNode(scheme);
        JsonCompat.setPropertyString(savedScheme, "__name", scheme.getSchemeName());
        this._oldSecuritySchemes.add(savedScheme);
        doc.components.removeSecurityScheme(scheme.getSchemeName());
    }
}

