/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.asyncapi.models.AaiServer;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;

public class RenameServerCommand_Aai20
extends AbstractCommand {
    public String _oldServerName;
    public String _newServerName;

    RenameServerCommand_Aai20() {
    }

    RenameServerCommand_Aai20(String oldServerName, String newServerName) {
        this._oldServerName = oldServerName;
        this._newServerName = newServerName;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[RenameServerCommand_Aai20] Executing.", new Object[0]);
        this._doServerRename((Aai20Document)document, this._oldServerName, this._newServerName);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[RenameServerCommand_Aai20] Reverting.", new Object[0]);
        this._doServerRename((Aai20Document)document, this._newServerName, this._oldServerName);
    }

    private void _doServerRename(Aai20Document document, String from, String to) {
        AaiServer aaiServer = null;
        if (ModelUtils.isDefined(document.servers)) {
            if (!this.isNullOrUndefined(document.servers.get(to))) {
                return;
            }
            aaiServer = (AaiServer)document.servers.remove(from);
        }
        if (this.isNullOrUndefined(aaiServer)) {
            return;
        }
        aaiServer.rename(to);
        document.servers.put(to, aaiServer);
    }
}

