/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiChannelItem;
import io.apicurio.datamodels.asyncapi.models.AaiDocument;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20NodeFactory;
import io.apicurio.datamodels.cmd.commands.ReplaceNodeCommand;
import io.apicurio.datamodels.core.models.Document;

public class ReplaceChannelItemCommand
extends ReplaceNodeCommand<AaiChannelItem> {
    public String _channelName;

    ReplaceChannelItemCommand() {
    }

    ReplaceChannelItemCommand(AaiChannelItem old, AaiChannelItem replacement) {
        super(old, replacement);
        this._channelName = replacement.getName();
    }

    @Override
    protected void removeNode(Document doc, AaiChannelItem node) {
        AaiDocument aaiDocument = (AaiDocument)doc;
        aaiDocument.channels.remove(node.getName());
    }

    @Override
    protected void addNode(Document doc, AaiChannelItem node) {
        AaiDocument aaiDocument = (AaiDocument)doc;
        node._ownerDocument = aaiDocument;
        node._parent = aaiDocument;
        aaiDocument.channels.put(this._channelName, node);
    }

    @Override
    protected AaiChannelItem readNode(Document doc, Object node) {
        AaiDocument aaiDocument = (AaiDocument)doc;
        AaiChannelItem channelItem = new Aai20NodeFactory().createChannelItem(aaiDocument, this._channelName);
        Library.readNode(node, channelItem);
        return channelItem;
    }
}

