/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.AbstractDescribedNode;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.DirectiveLocation;
import graphql.language.IgnoredChars;
import graphql.language.InputValueDefinition;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeChildrenContainer;
import graphql.language.NodeVisitor;
import graphql.language.SDLNamedDefinition;
import graphql.language.SourceLocation;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

@PublicApi
public class DirectiveDefinition
extends AbstractDescribedNode<DirectiveDefinition>
implements SDLNamedDefinition<DirectiveDefinition>,
NamedNode<DirectiveDefinition> {
    private final String name;
    private final boolean repeatable;
    private final ImmutableList<InputValueDefinition> inputValueDefinitions;
    private final ImmutableList<DirectiveLocation> directiveLocations;
    public static final String CHILD_INPUT_VALUE_DEFINITIONS = "inputValueDefinitions";
    public static final String CHILD_DIRECTIVE_LOCATION = "directiveLocation";

    @Internal
    protected DirectiveDefinition(String name, boolean repeatable, Description description, List<InputValueDefinition> inputValueDefinitions, List<DirectiveLocation> directiveLocations, SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData) {
        super(sourceLocation, comments, ignoredChars, additionalData, description);
        this.name = name;
        this.repeatable = repeatable;
        this.inputValueDefinitions = ImmutableList.copyOf(inputValueDefinitions);
        this.directiveLocations = ImmutableList.copyOf(directiveLocations);
    }

    public DirectiveDefinition(String name) {
        this(name, false, null, ImmutableKit.emptyList(), ImmutableKit.emptyList(), null, ImmutableKit.emptyList(), IgnoredChars.EMPTY, Collections.emptyMap());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public List<InputValueDefinition> getInputValueDefinitions() {
        return this.inputValueDefinitions;
    }

    public List<DirectiveLocation> getDirectiveLocations() {
        return this.directiveLocations;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.inputValueDefinitions);
        result.addAll(this.directiveLocations);
        return result;
    }

    @Override
    public NodeChildrenContainer getNamedChildren() {
        return NodeChildrenContainer.newNodeChildrenContainer().children(CHILD_INPUT_VALUE_DEFINITIONS, this.inputValueDefinitions).children(CHILD_DIRECTIVE_LOCATION, this.directiveLocations).build();
    }

    @Override
    public DirectiveDefinition withNewChildren(NodeChildrenContainer newChildren) {
        return this.transform(builder -> builder.inputValueDefinitions(newChildren.getChildren(CHILD_INPUT_VALUE_DEFINITIONS)).directiveLocations(newChildren.getChildren(CHILD_DIRECTIVE_LOCATION)));
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectiveDefinition that = (DirectiveDefinition)o;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public DirectiveDefinition deepCopy() {
        return new DirectiveDefinition(this.name, this.repeatable, this.description, this.deepCopy(this.inputValueDefinitions), this.deepCopy(this.directiveLocations), this.getSourceLocation(), this.getComments(), this.getIgnoredChars(), this.getAdditionalData());
    }

    public String toString() {
        return "DirectiveDefinition{name='" + this.name + "', inputValueDefinitions=" + this.inputValueDefinitions + ", directiveLocations=" + this.directiveLocations + "}";
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitDirectiveDefinition(this, context);
    }

    public static Builder newDirectiveDefinition() {
        return new Builder();
    }

    public DirectiveDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeBuilder {
        private SourceLocation sourceLocation;
        private ImmutableList<Comment> comments = ImmutableKit.emptyList();
        private String name;
        private boolean repeatable = false;
        private Description description;
        private ImmutableList<InputValueDefinition> inputValueDefinitions = ImmutableKit.emptyList();
        private ImmutableList<DirectiveLocation> directiveLocations = ImmutableKit.emptyList();
        private IgnoredChars ignoredChars = IgnoredChars.EMPTY;
        private Map<String, String> additionalData = new LinkedHashMap<String, String>();

        private Builder() {
        }

        private Builder(DirectiveDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = ImmutableList.copyOf(existing.getComments());
            this.name = existing.getName();
            this.repeatable = existing.isRepeatable();
            this.description = existing.getDescription();
            this.inputValueDefinitions = ImmutableList.copyOf(existing.getInputValueDefinitions());
            this.directiveLocations = ImmutableList.copyOf(existing.getDirectiveLocations());
            this.ignoredChars = existing.getIgnoredChars();
            this.additionalData = new LinkedHashMap<String, String>(existing.getAdditionalData());
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = ImmutableList.copyOf(comments);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder repeatable(boolean repeatable) {
            this.repeatable = repeatable;
            return this;
        }

        public Builder description(Description description) {
            this.description = description;
            return this;
        }

        public Builder inputValueDefinitions(List<InputValueDefinition> inputValueDefinitions) {
            this.inputValueDefinitions = ImmutableList.copyOf(inputValueDefinitions);
            return this;
        }

        public Builder inputValueDefinition(InputValueDefinition inputValueDefinition) {
            this.inputValueDefinitions = ImmutableKit.addToList(this.inputValueDefinitions, inputValueDefinition, new InputValueDefinition[0]);
            return this;
        }

        public Builder directiveLocations(List<DirectiveLocation> directiveLocations) {
            this.directiveLocations = ImmutableList.copyOf(directiveLocations);
            return this;
        }

        public Builder directiveLocation(DirectiveLocation directiveLocation) {
            this.directiveLocations = ImmutableKit.addToList(this.directiveLocations, directiveLocation, new DirectiveLocation[0]);
            return this;
        }

        @Override
        public Builder ignoredChars(IgnoredChars ignoredChars) {
            this.ignoredChars = ignoredChars;
            return this;
        }

        @Override
        public Builder additionalData(Map<String, String> additionalData) {
            this.additionalData = Assert.assertNotNull(additionalData);
            return this;
        }

        @Override
        public Builder additionalData(String key, String value) {
            this.additionalData.put(key, value);
            return this;
        }

        public DirectiveDefinition build() {
            return new DirectiveDefinition(this.name, this.repeatable, this.description, this.inputValueDefinitions, this.directiveLocations, this.sourceLocation, this.comments, this.ignoredChars, this.additionalData);
        }
    }
}

