/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility.jsonschema;

import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ArraySchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.BooleanSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.CombinedSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ConditionalSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ConstSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.EmptySchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.EnumSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.FalseSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.NotSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.NullSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.NumberSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ObjectSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ReferenceSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.SchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.StringSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.TrueSchemaWrapper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.everit.json.schema.CombinedSchema;

public abstract class JsonSchemaWrapperVisitor {
    public void visitSchema(SchemaWrapper schema) {
    }

    public void visitNumberSchema(NumberSchemaWrapper numberSchema) {
        this.visitSchema(numberSchema);
        this.visitRequiredInteger(numberSchema.requiresInteger());
        this.visitExclusiveMinimum(numberSchema.isExclusiveMinimum());
        this.visitMinimum(numberSchema.getMinimum());
        this.visitExclusiveMinimumLimit(numberSchema.getExclusiveMinimumLimit());
        this.visitExclusiveMaximum(numberSchema.isExclusiveMaximum());
        this.visitMaximum(numberSchema.getMaximum());
        this.visitExclusiveMaximumLimit(numberSchema.getExclusiveMaximumLimit());
        this.visitMultipleOf(numberSchema.getMultipleOf());
    }

    public void visitRequiredInteger(boolean requiresInteger) {
    }

    public void visitMinimum(Number minimum) {
    }

    public void visitExclusiveMinimum(boolean exclusiveMinimum) {
    }

    public void visitExclusiveMinimumLimit(Number exclusiveMinimumLimit) {
    }

    public void visitMaximum(Number maximum) {
    }

    public void visitExclusiveMaximum(boolean exclusiveMaximum) {
    }

    public void visitExclusiveMaximumLimit(Number exclusiveMaximumLimit) {
    }

    public void visitMultipleOf(Number multipleOf) {
    }

    public void visit(SchemaWrapper schema) {
        schema.accept(this);
    }

    public void visitArraySchema(ArraySchemaWrapper arraySchema) {
        this.visitSchema(arraySchema);
        this.visitMinItems(arraySchema.getMinItems());
        this.visitMaxItems(arraySchema.getMaxItems());
        this.visitUniqueItems(arraySchema.needsUniqueItems());
        if (arraySchema.getAllItemSchema() != null) {
            this.visitAllItemSchema(arraySchema.getAllItemSchema());
        }
        this.visitAdditionalItems(arraySchema.permitsAdditionalItems());
        if (arraySchema.getItemSchemas() != null) {
            this.visitItemSchemas(arraySchema.getItemSchemas());
        }
        if (arraySchema.getSchemaOfAdditionalItems() != null) {
            this.visitSchemaOfAdditionalItems(arraySchema.getSchemaOfAdditionalItems());
        }
        if (arraySchema.getContainedItemSchema() != null) {
            this.visitContainedItemSchema(arraySchema.getContainedItemSchema());
        }
    }

    public void visitItemSchemas(List<SchemaWrapper> itemSchemas) {
    }

    public void visitMinItems(Integer minItems) {
    }

    public void visitMaxItems(Integer maxItems) {
    }

    public void visitUniqueItems(boolean uniqueItems) {
    }

    public void visitAllItemSchema(SchemaWrapper allItemSchema) {
        this.visitSchema(allItemSchema);
    }

    public void visitAdditionalItems(boolean additionalItems) {
    }

    public void visitItemSchema(int index, SchemaWrapper itemSchema) {
        this.visitSchema(itemSchema);
    }

    public void visitSchemaOfAdditionalItems(SchemaWrapper schemaOfAdditionalItems) {
        this.visitSchema(schemaOfAdditionalItems);
    }

    public void visitContainedItemSchema(SchemaWrapper containedItemSchema) {
        this.visitSchema(containedItemSchema);
    }

    public void visitBooleanSchema(BooleanSchemaWrapper schema) {
        this.visitSchema(schema);
    }

    public void visitNullSchema(NullSchemaWrapper nullSchema) {
        this.visitSchema(nullSchema);
    }

    public void visitEmptySchema(EmptySchemaWrapper emptySchema) {
        this.visitSchema(emptySchema);
    }

    public void visitConstSchema(ConstSchemaWrapper constSchema) {
        this.visitSchema(constSchema);
        this.visitConstValue(constSchema.getPermittedValue());
    }

    public void visitConstValue(Object value) {
    }

    public void visitEnumSchema(EnumSchemaWrapper enumSchema) {
        this.visitSchema(enumSchema);
        this.visitEnumValues(enumSchema.getPossibleValues());
    }

    public void visitEnumValues(Set<Object> values) {
    }

    public void visitTrueSchema(TrueSchemaWrapper schema) {
        this.visitSchema(schema);
    }

    public void visitFalseSchema(FalseSchemaWrapper falseSchema) {
        this.visitSchema(falseSchema);
    }

    public void visitNotSchema(NotSchemaWrapper notSchema) {
        this.visitSchema(notSchema);
        this.visitSchemaMustNotMatch(notSchema.getMustNotMatch());
    }

    public void visitSchemaMustNotMatch(SchemaWrapper mustNotMatch) {
    }

    public void visitReferenceSchema(ReferenceSchemaWrapper referenceSchema) {
        this.visitSchema(referenceSchema);
        this.visitReferredSchema(referenceSchema.getReferredSchema());
    }

    public void visitReferredSchema(SchemaWrapper schema) {
    }

    public void visitObjectSchema(ObjectSchemaWrapper objectSchema) {
        Map<Pattern, SchemaWrapper> patternProperties;
        this.visitSchema(objectSchema);
        this.visitRequiredProperties(objectSchema.getRequiredProperties());
        if (objectSchema.getPropertyNameSchema() != null) {
            this.visitPropertyNameSchema(objectSchema.getPropertyNameSchema());
        }
        this.visitMinProperties(objectSchema.getMinProperties());
        this.visitMaxProperties(objectSchema.getMaxProperties());
        this.visitAllPropertyDependencies(objectSchema.getPropertyDependencies());
        this.visitAdditionalProperties(objectSchema.permitsAdditionalProperties());
        if (objectSchema.getSchemaOfAdditionalProperties() != null) {
            this.visitSchemaOfAdditionalProperties(objectSchema.getSchemaOfAdditionalProperties());
        }
        if ((patternProperties = objectSchema.getRegexpPatternProperties()) != null) {
            this.visitPatternProperties(patternProperties);
        }
        this.visitSchemaDependencies(objectSchema.getSchemaDependencies());
        Map<String, SchemaWrapper> propertySchemas = objectSchema.getPropertySchemas();
        if (propertySchemas != null) {
            this.visitPropertySchemas(propertySchemas);
        }
    }

    public void visitSchemaDependencies(Map<String, SchemaWrapper> schemaDependencies) {
        for (Map.Entry<String, SchemaWrapper> schemaDep : schemaDependencies.entrySet()) {
            this.visitSchemaDependency(schemaDep.getKey(), schemaDep.getValue());
        }
    }

    public void visitAllPropertyDependencies(Map<String, Set<String>> propertyDependencies) {
        for (Map.Entry<String, Set<String>> entry : propertyDependencies.entrySet()) {
            this.visitPropertyDependencies(entry.getKey(), entry.getValue());
        }
    }

    public void visitRequiredProperties(List<String> requiredProperties) {
        for (String requiredPropName : requiredProperties) {
            this.visitRequiredPropertyName(requiredPropName);
        }
    }

    public void visitPatternProperties(Map<Pattern, SchemaWrapper> patternProperties) {
        for (Map.Entry<Pattern, SchemaWrapper> entry : patternProperties.entrySet()) {
            this.visitPatternPropertySchema(entry.getKey(), entry.getValue());
        }
    }

    public void visitPropertySchemas(Map<String, SchemaWrapper> propertySchemas) {
    }

    public void visitPropertySchema(String propertyName, SchemaWrapper schema) {
        this.visitSchema(schema);
    }

    public void visitSchemaDependency(String propKey, SchemaWrapper schema) {
        this.visitSchema(schema);
    }

    public void visitPatternPropertySchema(Pattern propertyNamePattern, SchemaWrapper schema) {
        this.visitSchema(schema);
    }

    public void visitSchemaOfAdditionalProperties(SchemaWrapper schemaOfAdditionalProperties) {
        this.visitSchema(schemaOfAdditionalProperties);
    }

    public void visitAdditionalProperties(boolean additionalProperties) {
    }

    public void visitPropertyDependencies(String ifPresent, Set<String> allMustBePresent) {
    }

    public void visitMaxProperties(Integer maxProperties) {
    }

    public void visitMinProperties(Integer minProperties) {
    }

    public void visitPropertyNameSchema(SchemaWrapper propertyNameSchema) {
        this.visitSchema(propertyNameSchema);
    }

    public void visitRequiredPropertyName(String requiredPropName) {
    }

    public void visitStringSchema(StringSchemaWrapper stringSchema) {
        this.visitSchema(stringSchema);
        if (stringSchema.getMinLength() != null) {
            this.visitMinLength(stringSchema.getMinLength());
        }
        if (stringSchema.getMaxLength() != null) {
            this.visitMaxLength(stringSchema.getMaxLength());
        }
        if (stringSchema.getPattern() != null) {
            this.visitPattern(stringSchema.getPattern());
        }
        if (stringSchema.getFormatValidator() != null) {
            this.visitFormat(stringSchema.getFormatValidator().formatName());
        }
    }

    public void visitFormat(String formatName) {
    }

    public void visitPattern(Pattern pattern) {
    }

    public void visitMaxLength(Integer maxLength) {
    }

    public void visitMinLength(Integer minLength) {
    }

    public void visitCombinedSchema(CombinedSchemaWrapper combinedSchema) {
        this.visitSchema(combinedSchema);
        CombinedSchema.ValidationCriterion criterion = combinedSchema.getCriterion();
        if (CombinedSchema.ALL_CRITERION == criterion) {
            this.visitAllOfCombinedSchema(combinedSchema);
        } else if (CombinedSchema.ANY_CRITERION == criterion) {
            this.visitAnyOfCombinedSchema(combinedSchema);
        } else if (CombinedSchema.ONE_CRITERION == criterion) {
            this.visitOneOfCombinedSchema(combinedSchema);
        } else {
            throw new IllegalStateException("Could not determine if the combined schema is 'allOf', 'anyOf', or 'oneOf': " + combinedSchema);
        }
    }

    public void visitOneOfCombinedSchema(CombinedSchemaWrapper schema) {
    }

    public void visitAnyOfCombinedSchema(CombinedSchemaWrapper schema) {
    }

    public void visitAllOfCombinedSchema(CombinedSchemaWrapper schema) {
    }

    public void visitConditionalSchema(ConditionalSchemaWrapper conditionalSchema) {
        this.visitSchema(conditionalSchema);
        conditionalSchema.getIfSchema().ifPresent(this::visitIfSchema);
        conditionalSchema.getThenSchema().ifPresent(this::visitThenSchema);
        conditionalSchema.getElseSchema().ifPresent(this::visitElseSchema);
    }

    public void visitIfSchema(SchemaWrapper ifSchema) {
        this.visitSchema(ifSchema);
    }

    public void visitThenSchema(SchemaWrapper thenSchema) {
        this.visitSchema(thenSchema);
    }

    public void visitElseSchema(SchemaWrapper elseSchema) {
        this.visitSchema(elseSchema);
    }
}

