/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.MultiBroadcast;
import io.smallrye.mutiny.groups.MultiCollect;
import io.smallrye.mutiny.groups.MultiConvert;
import io.smallrye.mutiny.groups.MultiCreate;
import io.smallrye.mutiny.groups.MultiCreateBy;
import io.smallrye.mutiny.groups.MultiGroup;
import io.smallrye.mutiny.groups.MultiOnCancel;
import io.smallrye.mutiny.groups.MultiOnCompletion;
import io.smallrye.mutiny.groups.MultiOnEvent;
import io.smallrye.mutiny.groups.MultiOnFailure;
import io.smallrye.mutiny.groups.MultiOnItem;
import io.smallrye.mutiny.groups.MultiOnRequest;
import io.smallrye.mutiny.groups.MultiOnSubscribe;
import io.smallrye.mutiny.groups.MultiOnTerminate;
import io.smallrye.mutiny.groups.MultiOverflow;
import io.smallrye.mutiny.groups.MultiSelect;
import io.smallrye.mutiny.groups.MultiSkip;
import io.smallrye.mutiny.groups.MultiSubscribe;
import io.smallrye.mutiny.groups.MultiTransform;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public interface Multi<T>
extends Publisher<T> {
    public static MultiCreate createFrom() {
        return MultiCreate.INSTANCE;
    }

    public static MultiCreateBy createBy() {
        return MultiCreateBy.INSTANCE;
    }

    public MultiSubscribe<T> subscribe();

    public MultiOnItem<T> onItem();

    @Deprecated
    default public <O> O then(Function<Multi<T>, O> stage) {
        return this.stage(stage);
    }

    default public <O> O stage(Function<Multi<T>, O> stage) {
        return ParameterValidation.nonNull(stage, "stage").apply(this);
    }

    public Uni<T> toUni();

    public MultiOnFailure<T> onFailure();

    public MultiOnFailure<T> onFailure(Predicate<? super Throwable> var1);

    public MultiOnSubscribe<T> onSubscribe();

    public MultiOnFailure<T> onFailure(Class<? extends Throwable> var1);

    @Deprecated
    public MultiOnEvent<T> on();

    public Multi<T> cache();

    @Deprecated
    default public MultiCollect<T> collectItems() {
        return this.collect();
    }

    public MultiCollect<T> collect();

    public MultiGroup<T> group();

    @Deprecated
    default public MultiGroup<T> groupItems() {
        return this.group();
    }

    public Multi<T> emitOn(Executor var1);

    public Multi<T> runSubscriptionOn(Executor var1);

    public MultiOnCompletion<T> onCompletion();

    @Deprecated
    public MultiTransform<T> transform();

    public MultiSelect<T> select();

    public MultiSkip<T> skip();

    public MultiOverflow<T> onOverflow();

    public MultiBroadcast<T> broadcast();

    public MultiConvert<T> convert();

    default public Multi<T> filter(Predicate<? super T> predicate) {
        return this.select().where(predicate);
    }

    default public <O> Multi<O> map(Function<? super T, ? extends O> mapper) {
        return this.onItem().transform(mapper);
    }

    default public <O> Multi<O> flatMap(Function<? super T, ? extends Publisher<? extends O>> mapper) {
        return this.onItem().transformToMultiAndMerge(mapper);
    }

    default public Multi<T> call(Function<? super T, Uni<?>> action) {
        return this.onItem().call(action);
    }

    default public Multi<T> call(Supplier<Uni<?>> action) {
        return this.onItem().call(action);
    }

    default public Multi<T> invoke(Consumer<? super T> callback) {
        return this.onItem().invoke(ParameterValidation.nonNull(callback, "callback"));
    }

    default public Multi<T> invoke(Runnable callback) {
        return this.onItem().invoke(callback);
    }

    @Deprecated
    default public Multi<T> invokeUni(Function<? super T, Uni<?>> action) {
        return this.onItem().call(ParameterValidation.nonNull(action, "action"));
    }

    default public <O> Multi<O> concatMap(Function<? super T, ? extends Publisher<? extends O>> mapper) {
        return this.onItem().transformToMultiAndConcatenate(mapper);
    }

    public MultiOnTerminate<T> onTermination();

    public MultiOnCancel<T> onCancellation();

    public MultiOnRequest<T> onRequest();

    default public <R> Multi<R> plug(Function<Multi<T>, Multi<R>> operatorProvider) {
        Function<Multi<Multi>, Multi<R>> provider = ParameterValidation.nonNull(operatorProvider, "operatorProvider");
        return Infrastructure.onMultiCreation(ParameterValidation.nonNull(provider.apply(this), "multi"));
    }

    public Multi<T> toHotStream();
}

