/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

public class UniDelayUntil<T>
extends UniOperator<T, T> {
    private final Function<? super T, Uni<?>> function;
    private final ScheduledExecutorService executor;

    public UniDelayUntil(Uni<T> upstream, Function<? super T, Uni<?>> function, ScheduledExecutorService executor) {
        super(upstream);
        this.function = function;
        this.executor = executor;
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniDelayUntilProcessor(subscriber));
    }

    private class UniDelayUntilProcessor
    extends UniOperatorProcessor<T, T> {
        public UniDelayUntilProcessor(UniSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onItem(T item) {
            if (!this.isCancelled()) {
                try {
                    Uni uni = (Uni)UniDelayUntil.this.function.apply(item);
                    if (uni == null) {
                        super.onFailure(new NullPointerException("The function returned `null` instead of a valid `Uni`"));
                        return;
                    }
                    uni.runSubscriptionOn(UniDelayUntil.this.executor).subscribe().with(ignored -> super.onItem(item), x$0 -> super.onFailure((Throwable)x$0));
                }
                catch (RuntimeException e) {
                    super.onFailure(e);
                }
            }
        }
    }
}

