/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v2;

import io.apicurio.registry.rest.v2.beans.LogConfiguration;
import io.apicurio.registry.rest.v2.beans.NamedLogConfiguration;
import io.apicurio.registry.rest.v2.beans.RoleMapping;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.UpdateRole;
import io.apicurio.registry.types.RuleType;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/apis/registry/v2/admin")
public interface AdminResource {
    @Path(value="/rules")
    @GET
    @Produces(value={"application/json"})
    public List<RuleType> listGlobalRules();

    @Path(value="/rules")
    @POST
    @Consumes(value={"application/json"})
    public void createGlobalRule(Rule var1);

    @Path(value="/rules")
    @DELETE
    public void deleteAllGlobalRules();

    @Path(value="/rules/{rule}")
    @GET
    @Produces(value={"application/json"})
    public Rule getGlobalRuleConfig(@PathParam(value="rule") RuleType var1);

    @Path(value="/rules/{rule}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Rule updateGlobalRuleConfig(@PathParam(value="rule") RuleType var1, Rule var2);

    @Path(value="/rules/{rule}")
    @DELETE
    public void deleteGlobalRule(@PathParam(value="rule") RuleType var1);

    @Path(value="/loggers")
    @GET
    @Produces(value={"application/json"})
    public List<NamedLogConfiguration> listLogConfigurations();

    @Path(value="/loggers/{logger}")
    @GET
    @Produces(value={"application/json"})
    public NamedLogConfiguration getLogConfiguration(@PathParam(value="logger") String var1);

    @Path(value="/loggers/{logger}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public NamedLogConfiguration setLogConfiguration(@PathParam(value="logger") String var1, LogConfiguration var2);

    @Path(value="/loggers/{logger}")
    @DELETE
    @Produces(value={"application/json"})
    public NamedLogConfiguration removeLogConfiguration(@PathParam(value="logger") String var1);

    @Path(value="/export")
    @GET
    @Produces(value={"application/zip"})
    public Response exportData();

    @Path(value="/import")
    @POST
    @Consumes(value={"application/zip"})
    public void importData(InputStream var1);

    @Path(value="/roleMappings/{principalId}")
    @GET
    @Produces(value={"application/json"})
    public RoleMapping getRoleMapping(@PathParam(value="principalId") String var1);

    @Path(value="/roleMappings/{principalId}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateRoleMapping(@PathParam(value="principalId") String var1, UpdateRole var2);

    @Path(value="/roleMappings/{principalId}")
    @DELETE
    public void deleteRoleMapping(@PathParam(value="principalId") String var1);

    @Path(value="/roleMappings")
    @GET
    @Produces(value={"application/json"})
    public List<RoleMapping> listRoleMappings();

    @Path(value="/roleMappings")
    @POST
    @Consumes(value={"application/json"})
    public void createRoleMapping(RoleMapping var1);
}

