/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class CheckPeriodCache<K, V> {
    private Map<K, CheckValue<V>> cache = new ConcurrentHashMap<K, CheckValue<V>>();
    private long checkPeriodMillis = 0L;

    public CheckPeriodCache(long checkPeriodMillis) {
        this.checkPeriodMillis = checkPeriodMillis;
    }

    public V compute(K k, Function<K, V> remappingFunction) {
        CheckValue returnValue = this.cache.compute(k, (? super K key, ? super V checkedValue) -> {
            long now = System.currentTimeMillis();
            if (checkedValue == null) {
                Object value = remappingFunction.apply(key);
                return new CheckValue(now, value);
            }
            if (checkedValue.lastUpdate + this.checkPeriodMillis < now) {
                Object value = remappingFunction.apply(key);
                checkedValue.lastUpdate = now;
                checkedValue.value = value;
            }
            return checkedValue;
        });
        return returnValue.value;
    }

    public void put(K k, V v) {
        this.cache.put(k, new CheckValue<V>(System.currentTimeMillis(), v));
    }

    public V get(K k) {
        CheckValue value = this.cache.compute(k, (? super K key, ? super V checkedValue) -> {
            if (checkedValue == null) {
                return null;
            }
            long now = System.currentTimeMillis();
            if (checkedValue.lastUpdate + this.checkPeriodMillis < now) {
                return null;
            }
            return checkedValue;
        });
        return value == null ? null : (V)value.value;
    }

    public void remove(K k) {
        this.cache.remove(k);
    }

    public void clear() {
        this.cache.clear();
    }

    private static class CheckValue<V> {
        long lastUpdate;
        V value;

        CheckValue(long ts, V value) {
            this.lastUpdate = ts;
            this.value = value;
        }
    }
}

