/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry;

import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.impexp.EntityInputStream;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.utils.impexp.Entity;
import io.apicurio.registry.utils.impexp.EntityReader;
import io.quarkus.runtime.StartupEvent;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.zip.ZipInputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class ImportLifecycleBean {
    @Inject
    Logger log;
    @Inject
    @Current
    RegistryStorage storage;
    @ConfigProperty(name="registry.import.url")
    Optional<URL> registryImportUrlProp;

    void onStart(@Observes StartupEvent ev) {
        if (this.registryImportUrlProp.isPresent()) {
            this.log.info("Import URL exists.");
            final URL registryImportUrl = this.registryImportUrlProp.get();
            try (BufferedInputStream registryImportZip = new BufferedInputStream(registryImportUrl.openStream());){
                this.log.info("Importing {} on startup.", (Object)registryImportUrl);
                final ZipInputStream zip = new ZipInputStream((InputStream)registryImportZip, StandardCharsets.UTF_8);
                final EntityReader reader = new EntityReader(zip);
                try (EntityInputStream stream = new EntityInputStream(){

                    @Override
                    public Entity nextEntity() {
                        try {
                            return reader.readEntity();
                        }
                        catch (Exception e) {
                            ImportLifecycleBean.this.log.error("Error reading data from import ZIP file {}.", (Object)registryImportUrl, (Object)e);
                            return null;
                        }
                    }

                    @Override
                    public void close() throws IOException {
                        zip.close();
                    }
                };){
                    this.storage.importData(stream);
                    this.log.info("Registry successfully imported from {}", (Object)registryImportUrl);
                }
            }
            catch (IOException ioe) {
                this.log.warn("Registry import from {} failed", (Object)registryImportUrl, (Object)ioe);
            }
        }
    }
}

