/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@Singleton
public class AuthConfig {
    @Inject
    Logger log;
    @ConfigProperty(name="registry.auth.enabled", defaultValue="false")
    boolean authenticationEnabled;
    @ConfigProperty(name="registry.auth.role-based-authorization", defaultValue="false")
    boolean roleBasedAuthorizationEnabled;
    @ConfigProperty(name="registry.auth.owner-only-authorization", defaultValue="false")
    boolean ownerOnlyAuthorizationEnabled;
    @ConfigProperty(name="registry.auth.owner-only-authorization.limit-group-access", defaultValue="false")
    boolean ownerOnlyAuthorizationLimitGroupAccess;
    @ConfigProperty(name="registry.auth.anonymous-read-access.enabled", defaultValue="false")
    boolean anonymousReadAccessEnabled;
    @ConfigProperty(name="registry.auth.roles.readonly", defaultValue="sr-readonly")
    String readOnlyRole;
    @ConfigProperty(name="registry.auth.roles.developer", defaultValue="sr-developer")
    String developerRole;
    @ConfigProperty(name="registry.auth.roles.admin", defaultValue="sr-admin")
    String adminRole;
    @ConfigProperty(name="registry.auth.role-source", defaultValue="token")
    String roleSource;
    @ConfigProperty(name="registry.auth.tenant-owner-is-admin.enabled", defaultValue="true")
    boolean tenantOwnerIsAdminEnabled;
    @ConfigProperty(name="registry.auth.admin-override.enabled", defaultValue="false")
    boolean adminOverrideEnabled;
    @ConfigProperty(name="registry.auth.admin-override.from", defaultValue="token")
    String adminOverrideFrom;
    @ConfigProperty(name="registry.auth.admin-override.type", defaultValue="role")
    String adminOverrideType;
    @ConfigProperty(name="registry.auth.admin-override.role", defaultValue="sr-admin")
    String adminOverrideRole;
    @ConfigProperty(name="registry.auth.admin-override.claim", defaultValue="org-admin")
    String adminOverrideClaim;
    @ConfigProperty(name="registry.auth.admin-override.claim-value", defaultValue="true")
    String adminOverrideClaimValue;

    @PostConstruct
    void onConstruct() {
        this.log.debug("===============================");
        this.log.debug("Auth Enabled: " + this.authenticationEnabled);
        this.log.debug("Anonymous Read Access Enabled: " + this.anonymousReadAccessEnabled);
        this.log.debug("RBAC Enabled: " + this.roleBasedAuthorizationEnabled);
        if (this.roleBasedAuthorizationEnabled) {
            this.log.debug("   RBAC Roles: " + this.readOnlyRole + ", " + this.developerRole + ", " + this.adminRole);
            this.log.debug("   Role Source: " + this.roleSource);
        }
        this.log.debug("OBAC Enabled: " + this.ownerOnlyAuthorizationEnabled);
        this.log.debug("Tenant Owner is Admin: " + this.tenantOwnerIsAdminEnabled);
        this.log.debug("Admin Override Enabled: " + this.adminOverrideEnabled);
        if (this.adminOverrideEnabled) {
            this.log.debug("   Admin Override from: " + this.adminOverrideFrom);
            this.log.debug("   Admin Override type: " + this.adminOverrideType);
            this.log.debug("   Admin Override role: " + this.adminOverrideRole);
            this.log.debug("   Admin Override claim: " + this.adminOverrideClaim);
            this.log.debug("   Admin Override claim-value: " + this.adminOverrideClaimValue);
        }
        this.log.debug("===============================");
    }

    public boolean isAuthEnabled() {
        return this.authenticationEnabled;
    }

    public boolean isRbacEnabled() {
        return this.roleBasedAuthorizationEnabled;
    }

    public boolean isObacEnabled() {
        return this.ownerOnlyAuthorizationEnabled;
    }

    public boolean isTenantOwnerAdminEnabled() {
        return this.tenantOwnerIsAdminEnabled;
    }

    public boolean isAdminOverrideEnabled() {
        return this.adminOverrideEnabled;
    }

    public String getRoleSource() {
        return this.roleSource;
    }

    public boolean isApplicationRbacEnabled() {
        return this.roleBasedAuthorizationEnabled && "application".equals(this.getRoleSource());
    }
}

