/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.registry.auth.AdminOverride;
import io.apicurio.registry.auth.AuthConfig;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.OwnerBasedAccessController;
import io.apicurio.registry.auth.RoleBasedAccessApiOperation;
import io.apicurio.registry.auth.RoleBasedAccessController;
import io.apicurio.registry.mt.MultitenancyProperties;
import io.apicurio.registry.mt.TenantContext;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.SecurityIdentity;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;

@Authorized
@Interceptor
@Priority(value=2000)
public class AuthorizedInterceptor {
    @Inject
    Logger log;
    @Inject
    AuthConfig authConfig;
    @Inject
    SecurityIdentity securityIdentity;
    @Inject
    AdminOverride adminOverride;
    @Inject
    RoleBasedAccessController rbac;
    @Inject
    OwnerBasedAccessController obac;
    @Inject
    MultitenancyProperties mtProperties;
    @Inject
    TenantContext tenantContext;

    @AroundInvoke
    public Object authorizeMethod(InvocationContext context) throws Exception {
        if (this.mtProperties.isMultitenancyEnabled() && !this.tenantContext.isLoaded()) {
            this.log.warn("Request is rejected because the tenant could not be found, and access to default tenant is disabled in a multitenant deployment");
            throw new ForbiddenException("Default tenant access is not allowed in multitenancy mode.");
        }
        RoleBasedAccessApiOperation rbacOpAnnotation = context.getMethod().getAnnotation(RoleBasedAccessApiOperation.class);
        if (rbacOpAnnotation != null && !this.authConfig.isApplicationRbacEnabled()) {
            this.log.warn("Access to /admin/roleMappings denied because application managed RBAC is not enabled.");
            throw new ForbiddenException("Application RBAC not enabled.");
        }
        if (!this.authConfig.authenticationEnabled) {
            return context.proceed();
        }
        this.log.trace("Authentication enabled, protected resource: " + context.getMethod());
        if (this.securityIdentity == null || this.securityIdentity.isAnonymous()) {
            Authorized annotation = context.getMethod().getAnnotation(Authorized.class);
            if (annotation.level() == AuthorizedLevel.None) {
                this.log.trace("Anonymous user is being granted access to unprotected operation.");
                return context.proceed();
            }
            if (this.authConfig.anonymousReadAccessEnabled && annotation.level() == AuthorizedLevel.Read) {
                this.log.trace("Anonymous user is being granted access to read-only operation.");
                return context.proceed();
            }
            this.log.warn("Authentication credentials missing and required for protected endpoint.");
            throw new UnauthorizedException("User is not authenticated.");
        }
        this.log.trace("                               principalId:" + this.securityIdentity.getPrincipal().getName());
        if (this.adminOverride.isAdmin()) {
            this.log.trace("Admin override successful.");
            return context.proceed();
        }
        if (this.authConfig.roleBasedAuthorizationEnabled && !this.rbac.isAuthorized(context)) {
            this.log.warn("RBAC enabled and required role missing.");
            throw new ForbiddenException("User " + this.securityIdentity.getPrincipal().getName() + " is not authorized to perform the requested operation.");
        }
        if (this.authConfig.ownerOnlyAuthorizationEnabled && !this.obac.isAuthorized(context)) {
            this.log.warn("OBAC enabled and operation not permitted due to wrong owner.");
            throw new ForbiddenException("User " + this.securityIdentity.getPrincipal().getName() + " is not authorized to perform the requested operation.");
        }
        return context.proceed();
    }
}

