/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.registry.auth.AuthConfig;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.auth.IAccessController;
import io.apicurio.registry.storage.NotFoundException;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.types.Current;
import io.quarkus.security.identity.SecurityIdentity;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.interceptor.InvocationContext;

@Singleton
public class OwnerBasedAccessController
implements IAccessController {
    @Inject
    AuthConfig authConfig;
    @Inject
    SecurityIdentity securityIdentity;
    @Inject
    @Current
    RegistryStorage storage;

    @Override
    public boolean isAuthorized(InvocationContext context) {
        Authorized annotation = context.getMethod().getAnnotation(Authorized.class);
        AuthorizedStyle style = annotation.style();
        AuthorizedLevel level = annotation.level();
        if (level != AuthorizedLevel.Write) {
            return true;
        }
        if (style == AuthorizedStyle.GroupAndArtifact) {
            String groupId = OwnerBasedAccessController.getStringParam(context, 0);
            String artifactId = OwnerBasedAccessController.getStringParam(context, 1);
            return this.verifyArtifactCreatedBy(groupId, artifactId);
        }
        if (style == AuthorizedStyle.GroupOnly && this.authConfig.ownerOnlyAuthorizationLimitGroupAccess) {
            String groupId = OwnerBasedAccessController.getStringParam(context, 0);
            return this.verifyGroupCreatedBy(groupId);
        }
        if (style == AuthorizedStyle.ArtifactOnly) {
            String artifactId = OwnerBasedAccessController.getStringParam(context, 0);
            return this.verifyArtifactCreatedBy(null, artifactId);
        }
        if (style == AuthorizedStyle.GlobalId) {
            long globalId = OwnerBasedAccessController.getLongParam(context, 0);
            return this.verifyArtifactCreatedBy(globalId);
        }
        return true;
    }

    private boolean verifyGroupCreatedBy(String groupId) {
        try {
            GroupMetaDataDto dto = this.storage.getGroupMetaData(groupId);
            String createdBy = dto.getCreatedBy();
            return createdBy == null || createdBy.equals(this.securityIdentity.getPrincipal().getName());
        }
        catch (NotFoundException nfe) {
            return true;
        }
    }

    private boolean verifyArtifactCreatedBy(String groupId, String artifactId) {
        try {
            ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(groupId, artifactId);
            String createdBy = dto.getCreatedBy();
            return createdBy == null || createdBy.equals(this.securityIdentity.getPrincipal().getName());
        }
        catch (NotFoundException nfe) {
            return true;
        }
    }

    private boolean verifyArtifactCreatedBy(long globalId) {
        try {
            ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(globalId);
            String createdBy = dto.getCreatedBy();
            return createdBy == null || createdBy.equals(this.securityIdentity.getPrincipal().getName());
        }
        catch (NotFoundException nfe) {
            return true;
        }
    }

    private static String getStringParam(InvocationContext context, int index) {
        return (String)context.getParameters()[index];
    }

    private static Long getLongParam(InvocationContext context, int index) {
        return (Long)context.getParameters()[index];
    }
}

