/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.registry.auth.AuthConfig;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.IAccessController;
import io.apicurio.registry.auth.RoleProvider;
import io.apicurio.registry.auth.StorageRoleProvider;
import io.apicurio.registry.auth.TokenRoleProvider;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.interceptor.InvocationContext;

@Singleton
public class RoleBasedAccessController
implements IAccessController {
    @Inject
    AuthConfig authConfig;
    @Inject
    StorageRoleProvider storageRoleProvider;
    @Inject
    TokenRoleProvider tokenRoleProvider;

    @Override
    public boolean isAuthorized(InvocationContext context) {
        Authorized annotation = context.getMethod().getAnnotation(Authorized.class);
        AuthorizedLevel level = annotation.level();
        switch (level) {
            case Admin: {
                return this.isAdmin();
            }
            case None: {
                return true;
            }
            case Read: {
                return this.isReadOnly() || this.isDeveloper() || this.isAdmin();
            }
            case Write: {
                return this.isDeveloper() || this.isAdmin();
            }
        }
        throw new RuntimeException("Unhandled case: " + level);
    }

    public boolean isAdmin() {
        return this.getRoleProvider().isAdmin();
    }

    public boolean isDeveloper() {
        return this.getRoleProvider().isDeveloper();
    }

    public boolean isReadOnly() {
        return this.getRoleProvider().isReadOnly();
    }

    private RoleProvider getRoleProvider() {
        if ("token".equals(this.authConfig.roleSource)) {
            return this.tokenRoleProvider;
        }
        if ("application".equals(this.authConfig.roleSource)) {
            return this.storageRoleProvider;
        }
        throw new RuntimeException("Unsupported RBAC role source: " + this.authConfig.roleSource);
    }
}

