/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest.impl;

import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.ccompat.dto.CompatibilityLevelDto;
import io.apicurio.registry.ccompat.dto.CompatibilityLevelParamDto;
import io.apicurio.registry.ccompat.rest.ConfigResource;
import io.apicurio.registry.ccompat.rest.impl.AbstractResource;
import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.apicurio.registry.storage.RuleNotFoundException;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.types.RuleType;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.interceptor.Interceptors;

@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class ConfigResourceImpl
extends AbstractResource
implements ConfigResource {
    private CompatibilityLevelParamDto getCompatibilityLevel(Supplier<String> supplyLevel) {
        try {
            return new CompatibilityLevelParamDto(Optional.of(CompatibilityLevel.valueOf(supplyLevel.get())).get().name());
        }
        catch (RuleNotFoundException ex) {
            return new CompatibilityLevelParamDto(CompatibilityLevelDto.Level.NONE.name());
        }
    }

    private void updateCompatibilityLevel(CompatibilityLevelDto.Level level, Consumer<RuleConfigurationDto> updater, Runnable deleter) {
        if (level == CompatibilityLevelDto.Level.NONE) {
            deleter.run();
        } else {
            String levelString = level.getStringValue();
            try {
                CompatibilityLevel.valueOf(levelString);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Illegal compatibility level: " + levelString);
            }
            updater.accept(RuleConfigurationDto.builder().configuration(levelString).build());
        }
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public CompatibilityLevelParamDto getGlobalCompatibilityLevel() {
        return this.getCompatibilityLevel(() -> this.facade.getGlobalRule(RuleType.COMPATIBILITY).getConfiguration());
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public CompatibilityLevelDto updateGlobalCompatibilityLevel(CompatibilityLevelDto request) {
        this.updateCompatibilityLevel(request.getCompatibility(), dto -> this.facade.createOrUpdateGlobalRule(RuleType.COMPATIBILITY, (RuleConfigurationDto)dto), () -> this.facade.deleteGlobalRule(RuleType.COMPATIBILITY));
        return request;
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public CompatibilityLevelDto updateSubjectCompatibilityLevel(String subject, CompatibilityLevelDto request) {
        this.updateCompatibilityLevel(request.getCompatibility(), dto -> this.facade.createOrUpdateArtifactRule(subject, RuleType.COMPATIBILITY, (RuleConfigurationDto)dto), () -> this.facade.deleteArtifactRule(subject, RuleType.COMPATIBILITY));
        return request;
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public CompatibilityLevelParamDto getSubjectCompatibilityLevel(String subject) {
        return this.getCompatibilityLevel(() -> this.facade.getArtifactRule(subject, RuleType.COMPATIBILITY).getConfiguration());
    }
}

