/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest.impl;

import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaId;
import io.apicurio.registry.ccompat.dto.SchemaInfo;
import io.apicurio.registry.ccompat.rest.SubjectVersionsResource;
import io.apicurio.registry.ccompat.rest.impl.AbstractResource;
import io.apicurio.registry.ccompat.store.FacadeConverter;
import io.apicurio.registry.logging.Logged;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import java.util.List;
import javax.inject.Inject;
import javax.interceptor.Interceptors;
import javax.ws.rs.BadRequestException;

@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class SubjectVersionsResourceImpl
extends AbstractResource
implements SubjectVersionsResource {
    @Inject
    FacadeConverter converter;

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public List<Integer> listVersions(String subject) throws Exception {
        return this.facade.getVersions(subject);
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public SchemaId register(String subject, SchemaInfo request) throws Exception {
        Long id = this.facade.createSchema(subject, request.getSchema(), request.getSchemaType());
        int sid = this.converter.convertUnsigned(id);
        return new SchemaId(sid);
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public Schema getSchemaByVersion(String subject, String version) throws Exception {
        return this.facade.getSchema(subject, version);
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public int deleteSchemaVersion(String subject, String version) throws Exception {
        try {
            return this.facade.deleteSchema(subject, version);
        }
        catch (IllegalArgumentException ex) {
            throw new BadRequestException((Throwable)ex);
        }
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public String getSchemaOnly(String subject, String version) throws Exception {
        return this.facade.getSchema(subject, version).getSchema();
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public List<Integer> getSchemasReferencedBy(String subject, Integer version) throws Exception {
        return this.facade.getVersions(subject);
    }
}

