/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.store;

import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaInfo;
import io.apicurio.registry.ccompat.dto.SubjectVersion;
import io.apicurio.registry.ccompat.store.CCompatConfig;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.dto.StoredArtifactDto;
import io.apicurio.registry.types.ArtifactType;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FacadeConverter {
    @Inject
    CCompatConfig cconfig;

    public int convertUnsigned(long value) {
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Value out of unsigned integer range: " + value);
        }
        return (int)value;
    }

    public Schema convert(String subject, StoredArtifactDto storedArtifact) {
        return new Schema(this.convertUnsigned(this.cconfig.legacyIdModeEnabled ? storedArtifact.getGlobalId() : storedArtifact.getContentId()), subject, this.convertUnsigned(storedArtifact.getVersionId()), storedArtifact.getContent().content());
    }

    public SchemaInfo convert(ContentHandle content, ArtifactType artifactType) {
        return new SchemaInfo(content.content(), artifactType.value());
    }

    public SubjectVersion convert(String artifactId, Number version) {
        return new SubjectVersion(artifactId, version.longValue());
    }
}

