/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.store;

import io.apicurio.registry.ccompat.dto.CompatibilityCheckResponse;
import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaContent;
import io.apicurio.registry.ccompat.dto.SchemaInfo;
import io.apicurio.registry.ccompat.dto.SubjectVersion;
import io.apicurio.registry.ccompat.rest.error.ConflictException;
import io.apicurio.registry.ccompat.rest.error.UnprocessableEntityException;
import io.apicurio.registry.ccompat.store.CCompatConfig;
import io.apicurio.registry.ccompat.store.FacadeConverter;
import io.apicurio.registry.ccompat.store.RegistryStorageFacade;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.InvalidArtifactTypeException;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.RegistryStorageException;
import io.apicurio.registry.storage.RuleNotFoundException;
import io.apicurio.registry.storage.VersionNotFoundException;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.dto.StoredArtifactDto;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.util.ArtifactTypeUtil;
import io.apicurio.registry.util.VersionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class RegistryStorageFacadeImpl
implements RegistryStorageFacade {
    private static final Pattern QUOTED_BRACKETS = Pattern.compile(": *\"\\{}\"");
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RulesService rulesService;
    @Inject
    FacadeConverter converter;
    @Inject
    CCompatConfig cconfig;

    @Override
    public List<String> getSubjects() {
        return new ArrayList<String>(this.storage.getArtifactIds(null));
    }

    @Override
    public List<SubjectVersion> getSubjectVersions(int contentId) {
        if (this.cconfig.legacyIdModeEnabled) {
            ArtifactMetaDataDto artifactMetaData2 = this.storage.getArtifactMetaData(contentId);
            return Collections.singletonList(this.converter.convert(artifactMetaData2.getId(), artifactMetaData2.getVersionId()));
        }
        return this.storage.getArtifactVersionsByContentId(contentId).stream().map(artifactMetaData -> this.converter.convert(artifactMetaData.getId(), artifactMetaData.getVersionId())).collect(Collectors.toList());
    }

    @Override
    public List<Integer> deleteSubject(String subject) throws ArtifactNotFoundException, RegistryStorageException {
        return this.storage.deleteArtifact(null, subject).stream().map(VersionUtil::toInteger).map(this.converter::convertUnsigned).collect(Collectors.toList());
    }

    @Override
    public SchemaInfo getSchemaById(int contentId) throws ArtifactNotFoundException, RegistryStorageException {
        ContentHandle contentHandle;
        if (this.cconfig.legacyIdModeEnabled) {
            StoredArtifactDto artifactVersion = this.storage.getArtifactVersion(contentId);
            contentHandle = artifactVersion.getContent();
        } else {
            contentHandle = this.storage.getArtifactByContentId(contentId);
            List<ArtifactMetaDataDto> artifacts = this.storage.getArtifactVersionsByContentId(contentId);
            if (artifacts == null || artifacts.isEmpty()) {
                throw new ArtifactNotFoundException("ContentId: " + contentId);
            }
        }
        return this.converter.convert(contentHandle, ArtifactTypeUtil.determineArtifactType(this.removeQuotedBrackets(contentHandle.content()), null, null));
    }

    @Override
    public Schema getSchema(String subject, String versionString) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        return this.parseVersionString(subject, versionString, version -> {
            if (ArtifactState.DISABLED.equals((Object)this.storage.getArtifactVersionMetaData(null, subject, (String)version).getState())) {
                throw new VersionNotFoundException(null, subject, (String)version);
            }
            return this.converter.convert(subject, this.storage.getArtifactVersion(null, subject, (String)version));
        });
    }

    @Override
    public List<Integer> getVersions(String subject) throws ArtifactNotFoundException, RegistryStorageException {
        return this.storage.getArtifactVersions(null, subject).stream().map(VersionUtil::toLong).map(this.converter::convertUnsigned).sorted().collect(Collectors.toList());
    }

    @Override
    public Schema getSchema(String subject, SchemaContent schema) throws ArtifactNotFoundException, RegistryStorageException {
        ArtifactVersionMetaDataDto amd = this.storage.getArtifactVersionMetaData(null, subject, false, ContentHandle.create(schema.getSchema()));
        StoredArtifactDto storedArtifact = this.storage.getArtifactVersion(null, subject, amd.getVersion());
        return this.converter.convert(subject, storedArtifact);
    }

    @Override
    public Long createSchema(String subject, String schema, String schemaType) throws ArtifactAlreadyExistsException, ArtifactNotFoundException, RegistryStorageException {
        try {
            ContentHandle content = ContentHandle.create(schema);
            ArtifactVersionMetaDataDto dto = this.storage.getArtifactVersionMetaData(null, subject, false, content);
            return this.cconfig.legacyIdModeEnabled ? dto.getGlobalId() : dto.getContentId();
        }
        catch (ArtifactNotFoundException content) {
            try {
                ArtifactType artifactType = ArtifactTypeUtil.determineArtifactType(this.removeQuotedBrackets(schema), null, null);
                if (schemaType != null && !artifactType.value().equals(schemaType)) {
                    throw new UnprocessableEntityException(String.format("Given schema is not from type: %s", schemaType));
                }
                ArtifactMetaDataDto artifactMeta = this.createOrUpdateArtifact(subject, schema, artifactType);
                return this.cconfig.legacyIdModeEnabled ? artifactMeta.getGlobalId() : artifactMeta.getContentId();
            }
            catch (InvalidArtifactTypeException ex) {
                throw new UnprocessableEntityException(ex.getMessage());
            }
        }
    }

    @Override
    public int deleteSchema(String subject, String versionString) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        return VersionUtil.toInteger(this.parseVersionString(subject, versionString, version -> {
            this.storage.deleteArtifactVersion(null, subject, (String)version);
            return version;
        }));
    }

    @Override
    public void createOrUpdateArtifactRule(String subject, RuleType type, RuleConfigurationDto dto) {
        if (!this.doesArtifactRuleExist(subject, RuleType.COMPATIBILITY)) {
            this.storage.createArtifactRule(null, subject, RuleType.COMPATIBILITY, dto);
        } else {
            this.storage.updateArtifactRule(null, subject, RuleType.COMPATIBILITY, dto);
        }
    }

    @Override
    public void createOrUpdateGlobalRule(RuleType type, RuleConfigurationDto dto) {
        if (!this.doesGlobalRuleExist(RuleType.COMPATIBILITY)) {
            this.storage.createGlobalRule(RuleType.COMPATIBILITY, dto);
        } else {
            this.storage.updateGlobalRule(RuleType.COMPATIBILITY, dto);
        }
    }

    @Override
    public CompatibilityCheckResponse testCompatibilityBySubjectName(String subject, String version, SchemaContent request) {
        return this.parseVersionString(subject, version, v -> {
            try {
                ArtifactVersionMetaDataDto artifact = this.storage.getArtifactVersionMetaData(null, subject, (String)v);
                this.rulesService.applyRules(null, subject, (String)v, artifact.getType(), ContentHandle.create(request.getSchema()));
                return CompatibilityCheckResponse.IS_COMPATIBLE;
            }
            catch (RuleViolationException ex) {
                return CompatibilityCheckResponse.IS_NOT_COMPATIBLE;
            }
        });
    }

    private ContentHandle removeQuotedBrackets(String content) {
        return ContentHandle.create(QUOTED_BRACKETS.matcher(content).replaceAll(":{}"));
    }

    private ArtifactMetaDataDto createOrUpdateArtifact(String subject, String schema, ArtifactType artifactType) {
        ArtifactMetaDataDto res;
        try {
            if (!this.doesArtifactExist(subject)) {
                this.rulesService.applyRules(null, subject, artifactType, ContentHandle.create(schema), RuleApplicationType.CREATE);
                res = this.storage.createArtifact(null, subject, null, artifactType, ContentHandle.create(schema));
            } else {
                this.rulesService.applyRules(null, subject, artifactType, ContentHandle.create(schema), RuleApplicationType.UPDATE);
                res = this.storage.updateArtifact(null, subject, null, artifactType, ContentHandle.create(schema));
            }
        }
        catch (RuleViolationException ex) {
            if (ex.getRuleType() == RuleType.VALIDITY) {
                throw new UnprocessableEntityException(ex.getMessage(), ex);
            }
            throw new ConflictException(ex.getMessage(), ex);
        }
        return res;
    }

    @Override
    public <T> T parseVersionString(String subject, String versionString, Function<String, T> then) {
        String version;
        if ("latest".equals(versionString)) {
            ArtifactMetaDataDto latest = this.storage.getArtifactMetaData(null, subject);
            version = latest.getVersion();
        } else {
            try {
                Integer.parseUnsignedInt(versionString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal version format: " + versionString, e);
            }
            version = versionString;
        }
        return then.apply(version);
    }

    @Override
    public RuleConfigurationDto getGlobalRule(RuleType ruleType) {
        return this.storage.getGlobalRule(ruleType);
    }

    @Override
    public void deleteGlobalRule(RuleType ruleType) {
        this.storage.deleteGlobalRule(ruleType);
    }

    @Override
    public void deleteArtifactRule(String subject, RuleType ruleType) {
        this.storage.deleteArtifactRule(null, subject, ruleType);
    }

    @Override
    public RuleConfigurationDto getArtifactRule(String subject, RuleType ruleType) {
        return this.storage.getArtifactRule(null, subject, ruleType);
    }

    private boolean doesArtifactExist(String artifactId) {
        try {
            this.storage.getArtifact(null, artifactId);
            return true;
        }
        catch (ArtifactNotFoundException ignored) {
            return false;
        }
    }

    private boolean doesArtifactRuleExist(String artifactId, RuleType type) {
        try {
            this.storage.getArtifactRule(null, artifactId, type);
            return true;
        }
        catch (RuleNotFoundException ignored) {
            return false;
        }
    }

    private boolean doesGlobalRuleExist(RuleType type) {
        try {
            this.storage.getGlobalRule(type);
            return true;
        }
        catch (RuleNotFoundException ignored) {
            return false;
        }
    }
}

