/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.events.http;

import io.apicurio.registry.events.EventSink;
import io.apicurio.registry.events.http.HttpSinkConfiguration;
import io.apicurio.registry.events.http.HttpSinksConfiguration;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class HttpEventSink
implements EventSink {
    private HttpClient httpClient;
    @Inject
    Logger log;
    @Inject
    HttpSinksConfiguration sinksConfiguration;
    @Inject
    Vertx vertx;

    @Override
    public String name() {
        return "HTTP Sink";
    }

    @Override
    public boolean isConfigured() {
        return this.sinksConfiguration.isConfigured();
    }

    @Override
    public void handle(Message<Buffer> message) {
        String type = message.headers().get("type");
        this.log.info("Firing event " + type);
        for (HttpSinkConfiguration httpSink : this.sinksConfiguration.httpSinks()) {
            this.sendEventHttp(type, httpSink, (Buffer)message.body());
        }
    }

    private void sendEventHttp(String type, HttpSinkConfiguration httpSink, Buffer data) {
        try {
            this.log.debug("Sending event to sink " + httpSink.getName());
            ((HttpClientRequest)this.getHttpClient().request(new RequestOptions().setMethod(HttpMethod.POST).setURI(httpSink.getEndpoint()).putHeader("ce-id", UUID.randomUUID().toString()).putHeader("ce-specversion", "1.0").putHeader("ce-source", "apicurio-registry").putHeader("ce-type", type).putHeader("content-type", "application/json")).result()).exceptionHandler(ex -> this.log.error("Error sending event to " + httpSink.getEndpoint(), ex)).end(data);
        }
        catch (Exception e) {
            this.log.error("Error sending http event", (Throwable)e);
        }
    }

    private synchronized HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.vertx.createHttpClient(new HttpClientOptions().setConnectTimeout(15000));
        }
        return this.httpClient;
    }
}

